DROP TABLE contractor;

CREATE TABLE `contractor` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `phone` bigint(12) NOT NULL,
  `address` varchar(45) NOT NULL,
  `bank_details` varchar(45) NOT NULL,
  `other_details` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE estimates;

CREATE TABLE `estimates` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `project_id` int(3) NOT NULL,
  `project_name` varchar(40) NOT NULL,
  `work_type_id` int(3) NOT NULL,
  `work_type_name` varchar(40) NOT NULL,
  `estimate` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO estimates VALUES("2","1","XYZ Project","1","SAND","37500");
INSERT INTO estimates VALUES("3","1","XYZ Project","2","CEMENT","86000");



DROP TABLE expenses;

CREATE TABLE `expenses` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `project` int(3) NOT NULL,
  `floor_no` varchar(15) NOT NULL,
  `flat_no` varchar(10) NOT NULL,
  `date` date NOT NULL,
  `work_type` varchar(50) NOT NULL,
  `amount` float NOT NULL,
  `particulars` varchar(100) NOT NULL,
  `reference` varchar(50) NOT NULL,
  `comments` varchar(100) NOT NULL,
  `rcptphoto` varchar(60) NOT NULL,
  `payment_method` enum('cash','cheque','bank transfer') NOT NULL,
  `payment_details` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10080 DEFAULT CHARSET=latin1;

INSERT INTO expenses VALUES("8809","1","","","2017-06-03","97","10000","Mazhar Painter labour payment.","","","","cheque","3120","Mazhar");
INSERT INTO expenses VALUES("8810","1","","","2017-06-12","97","6500","Paid labor payment to Mazhar.","","","","cheque","Cheque No. 3129","Mazhar");
INSERT INTO expenses VALUES("8811","1","","","2017-06-15","97","13000","Rs 10000/- paid by cheque and Rs 3000 paid by cash. Total 13000/- labour payment paid to mazhar","","","","cheque","Cheque No. 3136","Mazhar");
INSERT INTO expenses VALUES("8812","1","","","2017-06-20","97","25000","Weekly Labour payment made to Mazhar.","","","","cheque","Cheque No. 3202","Mazhar");
INSERT INTO expenses VALUES("8813","1","","","2017-08-16","97","19000","Labor payment.","","","","cheque","Cheque No. 3220","Mazhar");
INSERT INTO expenses VALUES("8814","1","","","2017-08-19","97","13000","Labor payment","","","","cheque","Cheque No. 3224","Mazhar");
INSERT INTO expenses VALUES("8815","1","","","2017-08-24","97","8000","Labor Payment.","","","","cheque","Cheque No. 3230","Mazhar");
INSERT INTO expenses VALUES("8816","1","","","2017-09-01","97","5000","Paid mazhar Rs 15000/- out of which Rs 10000 Paid for murad Nagar work and Rs 5000 paid for tolichow","","","","cheque","Cheque No. 3235","Mazhar");
INSERT INTO expenses VALUES("8817","1","","","2017-10-21","97","10000","Labor payment.","","","","cheque","Cheque No. 3285","Mazhar");
INSERT INTO expenses VALUES("8818","1","","","2017-10-27","97","10000","Labor Payment","","","","cheque","Cheque No. 3303","Mazhar");
INSERT INTO expenses VALUES("8819","1","","","2017-11-08","97","5500","Total withdraw from bank is Rs 15000 out of which 9500 paid for Murad Nagar work. and Rs 5500 for To","","","","cheque","Cheque No. 3324","Mazhar");
INSERT INTO expenses VALUES("8820","1","","","2017-11-15","97","18000","Labor Payment.","","","","cheque","Cheque No. 3332","Mazhar");
INSERT INTO expenses VALUES("8821","1","","","2017-11-21","97","21000","Labor Payment","","","","cheque","Cheque No. 3341","Mazhar");
INSERT INTO expenses VALUES("8822","1","","","2017-12-01","97","25000","Labor Payment","","","","cheque","Cheque No. 3352","Mazhar");
INSERT INTO expenses VALUES("8823","1","","","2017-12-08","97","13000","Labor Payment.","","","","cheque","Cheque No. 3362","Mazhar");
INSERT INTO expenses VALUES("8824","1","","","2017-12-30","97","15000","Labour Payment.","","","","cheque","Cheque No. 3375","Mazhar");
INSERT INTO expenses VALUES("8825","1","","","2018-01-10","98","2000","Paid for tree cutting in front side. ","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8826","1","","","2018-01-10","18","10000","chipping of pent house and goa making. Total paid 10000/- for both work.","","","","cheque","Cheque No. 338","Shiva");
INSERT INTO expenses VALUES("8828","1","","","2018-01-10","10","37500","Labor payment ","","","","cheque"," 3377","Trupatty Swamy");
INSERT INTO expenses VALUES("8829","1","","","2018-01-10","2","58000","Purchase cement 200 bags @ 290 per bag and made payment ","","","","cheque","3381","Junaid");
INSERT INTO expenses VALUES("8830","1","","","2018-01-11","99","10000","Paid for piping work at penthouse for 2 flats.","","","","cheque","Cheque No. 3383","Yousuf");
INSERT INTO expenses VALUES("8831","1","","","2018-01-11","120","9000","Watchman salary paid for the month of December 2017.","","","","cheque","Cheque No. 3384","Ramesh");
INSERT INTO expenses VALUES("8832","1","","","2018-01-11","100","50000","Paid to shareef for purchase of matterial and sheet for 5 floor flats.","","","","cheque","Cheque No. 3385","Shareef");
INSERT INTO expenses VALUES("8833","1","","","2018-01-12","1","49000","sand purchase on 8 & 11 Jan 18. total 2 load bill paid.","","","","cheque","Cheque No. 3386","Venkateshwarlu");
INSERT INTO expenses VALUES("8834","1","","","2018-01-12","97","12000","Paid labor payment.","","","","cheque","Cheque No. 3388","Mazhar");
INSERT INTO expenses VALUES("8836","1","","","2018-01-12","77","50000","Paid to yousuf for purchase of wire 720 for lobby wiring. cheque was issue on Mukesh name.","","","","cheque","Cheque No. 3390","Yousuf ");
INSERT INTO expenses VALUES("8837","1","","","2017-03-10","99","84000","Total amount paid for piping of slabs @ Rs 14000/- per slab. Total 6 slabs.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8838","1","","","2017-04-07","99","72000","Total 18 flats wall piping done and paid Rs 4000 per flat.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8839","1","","","2017-04-21","99","20000","Labor payment paid for flats wall piping.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8840","1","","","2017-05-20","99","8000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8841","1","","","2017-05-23","99","4000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8842","1","","","2017-05-27","99","4000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8843","1","","","2017-05-28","99","5000","Work done for lobby piping.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8844","1","","","2017-06-12","99","7500","Work done for lobby piping.","","","","cheque","3126","Yousuf");
INSERT INTO expenses VALUES("8845","1","","","2017-06-23","99","5000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8846","1","","","2017-07-14","99","10000","Cash given to Yousuf Rs 5000 on 11-07-2018, Rs 5000 on 15-07-2018. & Rs 5000 used for other expenses","","","","cheque","3164","Yousuf");
INSERT INTO expenses VALUES("8848","1","","","2017-07-20","99","20000","Labor payment.","","","","cheque","3174","Yousuf");
INSERT INTO expenses VALUES("8849","1","","","2017-08-24","99","34000","Full & Final payment done for wall piping. Rs 17000 + Advance taken by yousuf + first floor wiring d","","","","cheque","Cheque No. 3232","Yousuf");
INSERT INTO expenses VALUES("8850","1","","","2017-09-16","99","18000","3 floor 6 flats wiring done.","","","","cheque","Cheque No. 3252","Yousuf");
INSERT INTO expenses VALUES("8851","1","","","2017-09-29","99","27000","9 flats wiring done.","","","","cheque","Cheque No. 3259","Yousuf");
INSERT INTO expenses VALUES("8852","1","","","2017-10-27","99","10000","Labor payment.","","","","cheque","Cheque No. 3305","Yousuf");
INSERT INTO expenses VALUES("8853","1","","","2017-11-03","99","23000","11 flats wiring done. paid payment.","","","","cheque","Cheque No. 3316","Yousuf");
INSERT INTO expenses VALUES("8854","1","","","2017-11-17","99","15000","5 flats wiring done amount paid.","","","","cheque","Cheque No. 3340","Yousuf");
INSERT INTO expenses VALUES("8855","1","","","2017-11-29","99","15000","Cheque withdraw on SELF of amount Rs 20000. out of which rs 5000 take by azeem","","","","cheque","Cheque No. 3347","Yousuf");
INSERT INTO expenses VALUES("8856","1","","","2018-01-17","1","10000","ssssssssssssssssssssssssssssssssss","","","","cheque","3120","azeem");
INSERT INTO expenses VALUES("8857","1","","","2018-01-17","95","11","ssssssssssss","","","","cheque","212","azeem");
INSERT INTO expenses VALUES("8859","1","","","2018-01-20","100","50000","Purchase of material and labor payment.","","","","cheque","3400","Yousuf");
INSERT INTO expenses VALUES("8860","1","","","2018-01-20","102","150000","Amount return to fzami as short of amount to pay insentive to nishant for the month of December 2017","","","","cheque","3399","Fzami");
INSERT INTO expenses VALUES("8862","1","","","2018-01-20","103","50000","Purchase of tiles for 1st flat that is 101 which is demo flat.","","","","cheque","3402","Patel");
INSERT INTO expenses VALUES("8863","1","","","2018-01-20","97","5000","Labor payment.","","","","cheque","3403","Mazhar");
INSERT INTO expenses VALUES("8865","1","","","2018-01-29","98","50000","DCM & labor payment for 2 days to bring tiles from Mehdi function hall.","","","","cheque","3404","Shafi & Azeem");
INSERT INTO expenses VALUES("8866","1","","","2018-03-24","104","10000","Paid weekly labor payment to kamal.","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8867","1","","","2018-03-31","104","9000","Paid weekly labour payment.","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8869","1","","","2018-04-07","104","15000","Paid weekly labour payment","","","","cheque","3601","Kamal");
INSERT INTO expenses VALUES("8871","1","","","2018-04-24","104","8000","Paid weekly labour payment","","","","cheque","3502","Kamal");
INSERT INTO expenses VALUES("8878","1","","","2018-03-17","105","50000","Advance payment for 3 flats","","","","cash","","Mujahaid");
INSERT INTO expenses VALUES("8879","1","","","2018-03-21","105","15000","Rs 15000 paid for material & Rs 5000 used for other expenses.","","","","cheque","3491","Mujahaid");
INSERT INTO expenses VALUES("8880","1","","","2018-03-28","105","15000","Labour payment","","","","cash","","Mujahaid");
INSERT INTO expenses VALUES("8882","1","","","2018-05-02","111","700","Paid internet bill for the month of April 2018","","","","cash","","Country online");
INSERT INTO expenses VALUES("8883","1","","","2017-10-11","101","15000","Paid weekly labour payment","","","","cheque","3294","Jamal");
INSERT INTO expenses VALUES("8884","1","","","2017-10-07","101","10000","Paid weekly labour payment","","","","cheque","3272","Jamal");
INSERT INTO expenses VALUES("8885","1","","","2017-10-13","101","30000","Paid weekly labour payment","","","","cheque","3295","Jamal");
INSERT INTO expenses VALUES("8886","1","","","2017-10-21","101","15000","Paid weekly labour payment","","","","cheque","3286","Waseem");
INSERT INTO expenses VALUES("8887","1","","","2017-10-27","101","15000","Paid weekly labour payment","","","","cheque","3306","Jamal");
INSERT INTO expenses VALUES("8888","1","","","2017-11-07","101","20000","Paid weekly labour payment","","","","cheque","3322","Jamal");
INSERT INTO expenses VALUES("8889","1","","","2017-11-10","101","20000","Paid weekly labour payment","","","","cheque","3329","Jamal");
INSERT INTO expenses VALUES("8890","1","","","2017-12-23","101","10000","Paid weekly labour payment","","","","cash","","Waseem");
INSERT INTO expenses VALUES("8891","1","","","2018-01-12","101","15000","Paid weekly labour payment","","","","cheque","3389","Waseem");
INSERT INTO expenses VALUES("8892","1","","","2018-01-20","101","15000","Paid weekly labour payment","","","","cheque","3401","Jamal");
INSERT INTO expenses VALUES("8893","1","","","2018-01-29","101","10000","Paid weekly labour payment ","","","","cheque","3490","Jamal");
INSERT INTO expenses VALUES("8894","1","","","2018-02-17","101","10000","Paid weekly labour payment","","","","cheque","3479","Jamal");
INSERT INTO expenses VALUES("8895","1","","","2018-02-26","101","20000","Paid weekly labour payment ","","","","cheque","3470","Jamal");
INSERT INTO expenses VALUES("8896","1","","","2018-03-03","101","10000","Rs 10000 Paid labour payment to Jamaal & Rs 5000 used for other expenditure.","","","","cheque","3441","Jamal");
INSERT INTO expenses VALUES("8897","1","","","2018-03-23","101","10000","Paid weekly labour payment","","","","cheque","3495","Jamal");
INSERT INTO expenses VALUES("8898","1","","","2018-03-31","101","10000","Paid weekly labour payment","","","","cash","","Jamal");
INSERT INTO expenses VALUES("8899","1","","","2018-04-07","101","15000","Paid weekly labour payment","","","","cheque","3600","Jamal");
INSERT INTO expenses VALUES("8900","1","","","2018-04-14","101","15000","Paid weekly labour payment","","","","cash","","Jamal");
INSERT INTO expenses VALUES("8901","1","","","2018-04-29","101","10000","Paid weekly labour payment","","","","cash","","Waseem");
INSERT INTO expenses VALUES("8902","1","","","2018-04-04","104","4000","Paid weekly labour payment","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8903","1","","","2018-04-14","104","10000","Paid weekly labour payment","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8904","1","","","2017-08-16","100","50000","Paid for 2 flats work 101 &108","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8905","1","","","2017-09-22","100","20000","Cash withdraw Rs 50000 from which Rs 20000 paid to shareef for 4 flats work. Rs 30000 used for other","","","","cheque","3292","Shareef");
INSERT INTO expenses VALUES("8906","1","","","2018-09-29","100","50000","Balance paid for 4 flats work","","","","cheque","3261","Shareef");
INSERT INTO expenses VALUES("8907","1","","","2017-10-16","100","30000","Paid weekly labour payment","","","","cheque","003299","Shareef");
INSERT INTO expenses VALUES("8908","1","","","2017-10-21","100","10000","Paid weekly labour payment","","","","cheque","3284","Shareef");
INSERT INTO expenses VALUES("8909","1","","","2017-10-27","100","20000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8910","1","","","2017-11-07","100","15000","Paid weekly labour payment","","","","cheque","3317","Shareef");
INSERT INTO expenses VALUES("8911","1","","","2017-11-10","100","50000","For purchase of chanel","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8912","1","","","2017-11-14","100","50000","Paid weekly labour payment","","","","cheque","3325","Shareef");
INSERT INTO expenses VALUES("8913","1","","","2017-12-02","100","50000","For purchase of material","","","","cheque","3348","Shareef");
INSERT INTO expenses VALUES("8914","1","","","2017-12-22","100","30000","Paid weekly labour payment","","","","cheque","3369","Shareef");
INSERT INTO expenses VALUES("8915","1","","","2017-12-30","100","10000","Paid weekly labour payment","","","","cheque","3376","Shareef");
INSERT INTO expenses VALUES("8916","1","","","2018-01-27","100","30000","For material &  weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8917","1","","","2018-01-28","100","15000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8918","1","","","2018-01-29","100","1000","Machine purchase","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8920","1","","","2018-02-01","100","15000","Cash withdraw from bank is Rs 16000 Paid weekly labour payment Rs 15000.","","","","cheque","3485","Shareef");
INSERT INTO expenses VALUES("8921","1","","","2018-02-03","100","49000","Material","","","","cheque","3408","Shareef");
INSERT INTO expenses VALUES("8922","1","","","2018-02-03","100","16000","Paid weekly labour payment","","","","cheque","3409","Shareef");
INSERT INTO expenses VALUES("8923","1","","","2018-02-16","100","30000","For material","","","","cheque","3430","Shareef");
INSERT INTO expenses VALUES("8924","1","","","2018-02-14","100","15000","Cash withdraw Rs 20000 but paid to shareef only Rs 15000 for material.","","","","cheque","3427","Shareef");
INSERT INTO expenses VALUES("8925","1","","","2018-02-17","100","20000","Paid weekly labour payment","","","","cheque","3481","Shareef");
INSERT INTO expenses VALUES("8926","1","","","2018-02-28","100","22000","Paid weekly labour payment","","","","cheque","3459","Shareef");
INSERT INTO expenses VALUES("8928","1","","","2018-02-18","100","10000","Paid weekly labour payment for pent house","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8929","1","","","2017-04-08","89","20000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8930","1","","","2017-04-15","89","5000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8931","1","","","2017-06-17","89","14000","Paid Rs 10000 by cheque & Rs 4000 by cash","","","","cheque","3138","Ibrahim");
INSERT INTO expenses VALUES("8932","1","","","2017-07-07","89","10000","Rs 8000 paid on 8-7-17 & Rs 2000 paid on 13-7-17.","","","","cheque","3156","Ibrahim");
INSERT INTO expenses VALUES("8934","1","","","2017-07-21","89","10000","Paid weekly labour payment","","","","cheque","3176","Ibrahim");
INSERT INTO expenses VALUES("8935","1","","","2017-08-05","89","5000","Paid weekly labour payment","","","","cheque","3204","Ibrahim");
INSERT INTO expenses VALUES("8936","1","","","2017-08-19","89","15000","Paid weekly labour payment","","","","cheque","3229","Ibrahim");
INSERT INTO expenses VALUES("8937","1","","","2017-10-21","89","10000","Paid labour payment for Murad nagar work.","","","","cheque","3283","Ibrahim");
INSERT INTO expenses VALUES("8939","1","","","2017-12-06","89","8000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8940","1","","","2018-02-01","89","25000","Rs 20000 paid by cheque & Rs 5000 paid by cash.","","","","cheque","3486","Ibrahim");
INSERT INTO expenses VALUES("8941","1","","","2018-03-17","89","10000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8942","1","","","2018-03-31","89","20000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8943","1","","","2018-04-07","89","10000","Paid weekly labour payment","","","","cheque","3599","Ibrahim");
INSERT INTO expenses VALUES("8944","1","","","2018-04-14","89","20000","Paid weekly labour payment. Full & final for bath room work","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8945","1","","","2017-10-07","89","8000","Paid weekly labour payment","","","","cheque","3271","Ibrahim");
INSERT INTO expenses VALUES("8946","1","","","2017-03-24","112","6000","Paid weekly labour payment","","","","cheque","3063","Zaki");
INSERT INTO expenses VALUES("8947","1","","","2017-02-28","112","3000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8948","1","","","2017-03-03","112","4000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8949","1","","","2017-03-18","112","25000","Paid weekly labour payment","","","","cheque","3058","Zaki");
INSERT INTO expenses VALUES("8950","1","","","2017-04-01","112","16000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8951","1","","","2017-04-08","112","8000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8952","1","","","2017-04-15","112","5000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8953","1","","","2017-05-20","112","12000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8954","1","","","2017-06-13","112","10000","Paid weekly labour payment","","","","cheque","3130","Zaki");
INSERT INTO expenses VALUES("8955","1","","","2017-06-23","112","6000","Paid weekly labour payment","","","","cheque","3141","Zaki");
INSERT INTO expenses VALUES("8956","1","","","2017-07-14","112","5000","Paid weekly labour payment","","","","cheque","3165","Zaki");
INSERT INTO expenses VALUES("8957","1","","","2017-08-17","112","20000","Paid weekly labour payment","","","","cheque","3223","Zaki");
INSERT INTO expenses VALUES("8958","1","","","2017-08-19","112","8000","Paid weekly labour payment","","","","cheque","3227","Zaki");
INSERT INTO expenses VALUES("8960","1","","","2017-08-25","112","50000","Hospital charges","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8963","1","","","2018-02-14","97","15000","Paid weekly labour payment","","","","cheque","3428","Mazher");
INSERT INTO expenses VALUES("8964","1","","","2017-02-17","97","30000","Paid weekly labour payment","","","","cheque","3478","Mazher");
INSERT INTO expenses VALUES("8965","1","","","2018-02-26","97","13000","Paid weekly labour payment","","","","cheque","3466","Mazher");
INSERT INTO expenses VALUES("8966","1","","","2018-03-07","97","10000","Paid weekly labour payment","","","","cheque","3593","Mazher");
INSERT INTO expenses VALUES("8967","1","","","2018-03-18","97","20000","Paid weekly labour payment at Mehdipatnam.","","","","cash","","Mazher");
INSERT INTO expenses VALUES("8968","1","","","2018-03-23","97","10000","Paid weekly labour payment","","","","cheque","3494","Mazher");
INSERT INTO expenses VALUES("8969","1","","","2018-02-17","99","20000","Paid weekly labour payment","","","","cheque","3480","Yousuf");
INSERT INTO expenses VALUES("8970","1","","","2018-03-25","99","10000","Paid weekly labour payment","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8971","1","","","2018-03-10","99","10000","Paid weekly labour payment","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8972","1","","","2018-04-28","104","5000","Paid Labor Payment","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8973","1","","","2018-02-03","107","15000","Rs 15000 paid Labor Payment to saddam & Rs 1000 used for other expenditure. ","","","","cheque","3413","Saddam");
INSERT INTO expenses VALUES("8974","1","","","2018-02-09","107","15000","Labor Payment.","","","","cheque","3420","Saddam");
INSERT INTO expenses VALUES("8975","1","","","2018-02-17","107","10000","Labor Payment.","","","","cheque","3477","Saddam");
INSERT INTO expenses VALUES("8976","1","","","2018-03-03","107","15000","Labor Payment.","","","","cheque","3442","Saddam");
INSERT INTO expenses VALUES("8977","1","","","2018-03-10","107","20000","Labor Payment.","","","","cash","","Saddam");
INSERT INTO expenses VALUES("8978","1","","","2017-06-23","10","50000","Labor Payment.","","","","cheque","3142","Trupatty");
INSERT INTO expenses VALUES("8979","1","","","2017-06-24","10","7000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8980","1","","","2017-06-27","10","8000","Trupatty charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8981","1","","","2017-07-01","10","65000","Labour payment + lifting charges + Trupatty charges","","","","cheque","3150","Trupatty");
INSERT INTO expenses VALUES("8982","1","","","2017-07-07","10","30000","Lifting charges + Trupatty charges","","","","cheque","3155","Trupatty");
INSERT INTO expenses VALUES("8983","1","","","2017-07-15","10","90000","2 weeks laboour payment + Trupatty charges.( 80000+10000 )","","","","cheque","3166  &  3169","Trupatty");
INSERT INTO expenses VALUES("8984","1","","","2017-07-21","10","50000","Labour payment","","","","cheque","3175","Trupatty");
INSERT INTO expenses VALUES("8985","1","","","2017-08-02","10","50000","Labour payment","","","","cheque","3189","Trupatty");
INSERT INTO expenses VALUES("8986","1","","","2017-08-05","10","20000","Lifting charges + Trupatty charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8987","1","","","2017-08-05","10","45000","Lifting charges + Trupatty charges","","","","cheque","3208","Trupatty");
INSERT INTO expenses VALUES("8988","1","","","2017-08-11","10","12000","Lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8989","1","","","2017-08-11","10","200000","Advance ","","","","cheque","3214","Trupatty");
INSERT INTO expenses VALUES("8990","1","","","2017-08-19","10","40000","Labour payment + shifting charges","","","","cheque","3226","Trupatty");
INSERT INTO expenses VALUES("8991","1","","","2017-08-24","10","45000","Labour payment + shifting charges","","","","cheque","3231","Trupatty");
INSERT INTO expenses VALUES("8992","1","","","2017-09-09","10","60000","2 weeks labour payment + lifting charges","","","","cheque","3238","Trupatty");
INSERT INTO expenses VALUES("8993","1","","","2017-09-13","10","20000","Lifting charges + Trupatty charges","","","","cheque","3249","Trupatty");
INSERT INTO expenses VALUES("8994","1","","","2017-09-16","10","41000","Rs 23000 paid by cheque  & Rs 18000 paid b","","","","cheque","3253","Trupatty");
INSERT INTO expenses VALUES("8995","1","","","2017-09-23","10","20000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8996","1","","","2017-10-03","10","52000","Labour payment for 3 weeks. & Rs 52000 paid to Tirupathi.","","","","cheque","3275","Trupatty");
INSERT INTO expenses VALUES("8997","1","","","2017-10-14","10","30000","Labour payment + Trupatty charges","","","","cheque","003278","Trupatty");
INSERT INTO expenses VALUES("8998","1","","","2017-10-21","10","36000","Labour payment + Trupatty charges","","","","cheque","3287","Trupatty");
INSERT INTO expenses VALUES("8999","1","","","2017-10-27","10","30000","Labour payment + Trupatty charges","","","","cheque","3302","Trupatty");
INSERT INTO expenses VALUES("9000","1","","","2017-11-06","10","33000","Labour payment + Trupatty charges","","","","cheque","3319","Trupatty");
INSERT INTO expenses VALUES("9001","1","","","2017-11-10","10","24000","Labour payment + Labour payment for columns","","","","cheque","3330","Trupatty");
INSERT INTO expenses VALUES("9002","1","","","2017-11-29","10","10000","Rs 10000 Labour payment paid to Trupatty. & Rs 10000 used for other expenses.","","","","cheque","3346","Trupatty");
INSERT INTO expenses VALUES("9003","1","","","2017-12-15","10","10000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9004","1","","","2017-12-16","10","25000","Rethi lifting + Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9005","1","","","2018-05-05","10","25000","Labour payment","","","","cheque","3616","Trupatty");
INSERT INTO expenses VALUES("9006","1","","","2017-12-22","10","36000","Labour payment + Bricks lifting","","","","cheque","3368","Trupatty");
INSERT INTO expenses VALUES("9007","1","","","2017-12-30","10","30000","Paid Labour payment .","","","","cheque","3374","Trupatty");
INSERT INTO expenses VALUES("9009","1","","","2018-01-12","10","80000","Trupatty advance amt RS 50000 + Labour payment Rs 30000.","","","","cheque","3387","Trupatty");
INSERT INTO expenses VALUES("9010","1","","","2018-01-29","10","20000","Paid to Mahboob for sand lifting.","","","","cheque","3405","Trupatty");
INSERT INTO expenses VALUES("9011","1","","","2018-01-24","10","14000","Sand lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9012","1","","","2018-02-03","10","30000","Labour payment","","","","cheque","3410","Trupatty");
INSERT INTO expenses VALUES("9013","1","","","2018-02-12","10","35000","Labour payment","","","","cheque","3425","Trupatty");
INSERT INTO expenses VALUES("9014","1","","","2018-02-17","10","25000","Labour payment","","","","cheque","3436","Trupatty");
INSERT INTO expenses VALUES("9015","1","","","2018-02-26","10","37000","Labour payment","","","","cheque","3468","Trupatty");
INSERT INTO expenses VALUES("9016","1","","","2018-03-03","10","20000","Rs 20000 paid Labour payment to Tirupathi & Rs 4000 used for other expenditure. ","","","","cheque","3591","Trupatty");
INSERT INTO expenses VALUES("9017","1","","","2018-03-10","10","41000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9018","1","","","2018-03-10","10","8000","Sand lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9019","1","","","2018-03-17","10","25000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9020","1","","","2018-03-23","10","25000","Labour payment","","","","cheque","3497","Trupatty");
INSERT INTO expenses VALUES("9021","1","","","2018-03-28","10","10000","Advance Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9022","1","","","2018-04-04","10","3500","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9023","1","","","2018-04-07","10","44000","Cheque was issue for amount of 60000/-. Labour payment was 44000 other charges like digging and mate","","","","cheque","3598","Trupatty");
INSERT INTO expenses VALUES("9024","1","","","2018-04-14","10","19000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9025","1","","","2018-04-21","10","15000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9026","1","","","2018-05-02","10","10000","Labour payment","","","","cheque","3614","Trupatty");
INSERT INTO expenses VALUES("9027","1","","","2018-05-05","103","12000","Bathroom tiles purchase for 10 bathrooms. Rs 12000 paid in advance and rest Rs 30000/- by cheque on ","","","","cash","","Patel");
INSERT INTO expenses VALUES("9028","1","","","2018-05-05","113","21600","Granite 300 sq feet purchase for staircase landing. bill include of labor and transport. total withd","","","","cash","","Anil");
INSERT INTO expenses VALUES("9029","1","","","2016-10-26","10","90000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9031","1","","","2016-12-27","10","50000","Labour payment","","","","cheque","2994","Trupatty");
INSERT INTO expenses VALUES("9032","1","","","2016-12-27","10","8000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9033","1","","","2017-01-09","10","50000","Labour payment","","","","cheque","2999","Trupatty");
INSERT INTO expenses VALUES("9034","1","","","2017-01-07","10","30000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9035","1","","","2017-01-14","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9036","1","","","2017-01-21","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9037","1","","","2017-01-21","10","3000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9038","1","","","2017-01-21","10","8000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9039","1","","","2017-01-28","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9040","1","","","2017-02-03","10","50000","Labour payment","","","","cheque","3014","Trupatty");
INSERT INTO expenses VALUES("9041","1","","","2017-02-04","10","50000","Labour payment","","","","cheque","3013","Trupatty");
INSERT INTO expenses VALUES("9042","1","","","2017-02-11","10","45000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9043","1","","","2017-02-18","10","45000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9044","1","","","2017-02-26","10","80000","Labour payment ( Rs 50000 paid by cheque & Rs 30000 paid by cash )","","","","cheque","","Trupatty");
INSERT INTO expenses VALUES("9045","1","","","2017-03-04","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9046","1","","","2017-03-04","10","7500","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9047","1","","","2017-03-04","10","20000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9048","1","","","2017-03-11","10","58000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9049","1","","","2017-03-11","10","8000","Rethi lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9050","1","","","2017-03-11","10","8500","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9051","1","","","2017-03-11","10","5500","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9052","1","","","2017-03-21","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9053","1","","","2017-03-20","10","19500","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9054","1","","","2017-03-22","10","12500","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9055","1","","","2017-03-25","10","56000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9056","1","","","2017-03-27","10","50000","Labour payment","","","","cheque","3069","Trupatty");
INSERT INTO expenses VALUES("9057","1","","","2017-04-01","10","30000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9058","1","","","2017-04-08","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9059","1","","","2017-04-15","10","45000","Rs 18000 paid by cheque on 17-4-2018. Remaining amount paid by cash.","","","","cheque","3080","Trupatty");
INSERT INTO expenses VALUES("9060","1","","","2018-05-07","110","150000","TRFR TO: REHAN SHARIEF","","","","cheque","003505","Rehan Sharief");
INSERT INTO expenses VALUES("9061","1","","","2018-05-07","103","30000","Balance payment for Tiles Purchase","","","","cheque","003506","Patel");
INSERT INTO expenses VALUES("9062","1","","","2017-04-25","10","50000","Labour payment","","","","cheque","3081","Trupatty");
INSERT INTO expenses VALUES("9063","1","","","2018-05-07","123","15000","Amount paid for 3D designing  brouchers","","","","cheque","003619","Trupatty");
INSERT INTO expenses VALUES("9064","1","","","2017-04-29","10","50000","Labour payment","","","","cheque","3089","Trupatty");
INSERT INTO expenses VALUES("9065","1","","","2017-05-06","10","50000","Labour payment","","","","cheque","3097","Trupatty");
INSERT INTO expenses VALUES("9066","1","","","2017-05-13","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9067","1","","","2017-05-15","10","9000","Labour payment","","","","cheque","3108","Trupatty");
INSERT INTO expenses VALUES("9068","1","","","2017-05-20","10","50000","Labour payment","","","","cheque","3111","Trupatty");
INSERT INTO expenses VALUES("9069","1","","","2017-05-26","10","50000","Labour payment","","","","cheque","3112","Trupatty");
INSERT INTO expenses VALUES("9070","1","","","2017-05-27","10","8000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9071","1","","","2017-06-03","10","50000","Labour payment","","","","cheque","3117","Trupatty");
INSERT INTO expenses VALUES("9072","1","","","2017-06-06","10","10000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9073","1","","","2017-06-10","10","42000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9074","1","","","2017-06-10","10","8000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9075","1","","","2017-06-10","10","4000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9076","1","","","2017-06-17","10","60000","Labour payment","","","","cheque","3140","Trupatty");
INSERT INTO expenses VALUES("9077","1","","","2016-08-01","11","400000","Paid amount for Ground floor slab. Total 117 Qubic Meter @ Rs 3500.","","","","cheque","2979","Sai Ram");
INSERT INTO expenses VALUES("9078","1","","","2016-08-12","11","400000","Paid amount for Ground floor slab. Total 117 Qubic Meter @ Rs 3500. Second payment.","","","","cheque","2981","Sai Ram");
INSERT INTO expenses VALUES("9079","1","","","2016-09-21","11","400000","Paid amount for slab. ","","","","cheque","2985","Sai Ram");
INSERT INTO expenses VALUES("9080","1","","","2016-12-05","11","300000","Amount paid for reddy mix slab.","","","","cash","","Sai Ram");
INSERT INTO expenses VALUES("9081","1","","","2017-02-20","11","200000","Paid amount for slab work to Rank Silicon. ","","","","cheque","3009","Sai Ram");
INSERT INTO expenses VALUES("9082","1","","","2017-02-04","11","200000","Amount paid for slab to Rank silicon.","","","","cheque","3008","Sai Ram");
INSERT INTO expenses VALUES("9083","1","","","2017-04-04","11","200000","Paid amount to Rank silicon for reddy mix slab.","","","","cheque","3010","Sai Ram");
INSERT INTO expenses VALUES("9084","1","","","2017-05-04","11","100000","Paid amount to Rank silicon for reddy mix slab.","","","","cheque","3095","Sai Ram");
INSERT INTO expenses VALUES("9085","1","","","2017-06-02","11","150000","Paid amount to Rank silicon for reddy mix.","","","","cheque","3193","Sai Ram");
INSERT INTO expenses VALUES("9086","1","","","2017-09-21","11","110000","full and final payment to rank silicon.","","","","cheque","3256","Sai Ram");
INSERT INTO expenses VALUES("9087","1","","","2017-02-06","14","62400","Transfer to NALLA VERRIYYA
\n","","","","cheque","3015","Babu");
INSERT INTO expenses VALUES("9088","1","","","2017-03-07","14","62725","TRFR TO:NALLA RAMBABU","","","","cheque","3045","Babu");
INSERT INTO expenses VALUES("9089","1","","","2017-03-16","14","63000","Transfer to VERRIYYA NALLA","","","","cheque","3055","Babu");
INSERT INTO expenses VALUES("9090","1","","","2017-01-24","77","20000","Purchase  material from Mukesh electricals","","","","cheque","3006","DEVA");
INSERT INTO expenses VALUES("9091","1","","","2017-02-06","77","22000","Purchase  material from Mukesh electricals","","","","cheque","3007","DEVA");
INSERT INTO expenses VALUES("9092","1","","","2017-03-17","77","22000","Purchase  material from Mukesh electricals","","","","cheque","3047","DEVA");
INSERT INTO expenses VALUES("9093","1","","","2017-02-08","2","42750","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3017","JUNAID");
INSERT INTO expenses VALUES("9094","1","","","2017-02-22","2","55000","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3036","JUNAID");
INSERT INTO expenses VALUES("9095","1","","","2017-03-10","2","53600","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3051","JUNAID");
INSERT INTO expenses VALUES("9096","1","","","2017-01-02","1","50000","Transfer to MALLE VENKATESHWARLU","","","","cheque","2993","VENKATESH");
INSERT INTO expenses VALUES("9097","1","","","2017-03-10","1","50000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3048","VENKATESH");
INSERT INTO expenses VALUES("9098","1","","","2017-03-16","1","40000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3024","VENKATESH");
INSERT INTO expenses VALUES("9099","1","","","2017-03-22","1","50000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3034","VENKATESH");
INSERT INTO expenses VALUES("9100","1","","","2017-03-14","1","10000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3054","VENKATESH");
INSERT INTO expenses VALUES("9101","1","","","2017-03-08","5","142122","Purchase sanitary material from SRI LAXMI SALES CORPORATI","","","","cheque","3042","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9102","1","","","2017-02-06","114","200000","STEEL PURCHASE FROM KESHREE METALURGIES PVT L","","","","cheque","3016","KESHREE METAL");
INSERT INTO expenses VALUES("9103","1","","","2017-02-21","114","100000","STEEL PURCHASE FROM KESHREE METALURGIES PVT L","","","","cheque","3031","KESHREE METAL");
INSERT INTO expenses VALUES("9104","1","","","2017-03-16","114","83700","STEEL PURCHASE FROM KESHREE METALURGIES PVT L","","","","cheque","3052","KESHREE METAL");
INSERT INTO expenses VALUES("9105","1","","","2017-02-15","95","26217","Paid electricity bill
\n","","","","cheque","3019","Electricity bill ");
INSERT INTO expenses VALUES("9106","1","","","2017-01-30","115","288","Paid Tata Bills","","","","cash","","Phone Bill");
INSERT INTO expenses VALUES("9107","1","","","2017-03-08","115","1840","Paid Tata Bills","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9108","1","","","2017-02-16","116","3300","Paid to carpenter shabbir","","","","cheque","3026","Shabbir");
INSERT INTO expenses VALUES("9109","1","","","2017-02-22","116","50000","Paid to Shabbir
\n","","","","cheque","3032","Shabbir");
INSERT INTO expenses VALUES("9110","1","","","2017-03-14","116","50000","Paid to Shabbir
\n","","","","cheque","3056","Shabbir");
INSERT INTO expenses VALUES("9111","1","","","2017-03-20","116","31050","Paid to Sabbir","","","","cheque","3060","Shabbir");
INSERT INTO expenses VALUES("9112","1","","","2017-01-30","115","1004","Paid Tata Bills","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9113","1","","","2017-01-19","102","10000","TRFR TO:FZAMI ONLINE SERVICES","","","","cheque","3004","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9114","1","","","2017-01-16","116","46000","CASH PAID:SHABBER AHMED	","","","","cheque","3002","Shabbir");
INSERT INTO expenses VALUES("9115","1","","","2017-01-12","114","70000","Paid to H S M Steels.
\n","","","","cheque","2998","HSM Steels");
INSERT INTO expenses VALUES("9116","1","","","2017-03-30","2","53600","Purchase cement from INDIA STEEL ENTERPRISES
\n","","","","cheque","3074","JUNAID");
INSERT INTO expenses VALUES("9117","1","","","2017-03-28","1","40000","Paid to VENKATESH","","","","cheque","3071","VENKATESH");
INSERT INTO expenses VALUES("9118","1","","","2017-03-29","14","90000","Transfer to VERRIYYA NALLA			
\n","","","","cheque","3064","Babu");
INSERT INTO expenses VALUES("9119","1","","","2017-03-31","95","14439","Paid Electricity Bill","","","","cheque","3068","Electricity bill ");
INSERT INTO expenses VALUES("9120","1","","","2018-05-11","101","15000","Rs 10000 paid by cheque & Rs 5000 paid by cash.","","","","cheque","3637","Jamal");
INSERT INTO expenses VALUES("9121","1","","","2018-05-19","101","8000","Paid cash taken form advance of flat sale.","","","","cash","","Jamal");
INSERT INTO expenses VALUES("9123","1","","","2016-07-22","114","532454","Steel purchase from KESHREE METALURGIES PVT Ltd. ","","","","cheque","2976","KESHREE METAL");
INSERT INTO expenses VALUES("9124","1","","","2016-08-17","114","37000","Steel purchase from iqbal steel.","","","","cheque","2980","H S M STEELS");
INSERT INTO expenses VALUES("9125","1","","","2016-07-25","2","50000","Purchase of cement.","","","","cheque","2977","Ghouse");
INSERT INTO expenses VALUES("9126","1","","","2016-08-17","2","60000","Cheque issue on SELF. Purchase of cement. ","","","","cheque","2983","Ghouse");
INSERT INTO expenses VALUES("9127","1","","","2016-09-19","118","816","Bank charges debited from account.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9128","1","","","2016-08-17","119","17500","Dont remember about this entry.","","","","cheque","2982","SWANTH RAJ");
INSERT INTO expenses VALUES("9129","1","","","2016-09-22","119","474283","Dont remember the entry.","","","","cheque","2984","VIBGYOR TECHNICAL SERVICES");
INSERT INTO expenses VALUES("9130","1","","","2016-07-15","118","287","Bank charges.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9131","1","","","2016-11-22","115","410","Paid Land line bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9132","1","","","2016-11-29","115","865","Paid Land line bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9133","1","","","2016-12-31","115","2176","Land line bill paid.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9134","1","","","2016-11-21","115","862","Land line bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9135","1","","","2016-10-15","114","362074","Steel purchase from KESHREE METALRGIES PLTD	","","","","cheque","2986","KESHREE METAL");
INSERT INTO expenses VALUES("9136","1","","","2016-12-23","1","50000","Sand purchase from MALLE VENKATESHWARLU
\n","","","","cheque","2992","VENKATESH");
INSERT INTO expenses VALUES("9137","1","","","2016-12-26","116","28500","Paid to SHABBIR AHMED			
\n","","","","cheque","2990","Shabbir");
INSERT INTO expenses VALUES("9138","1","","","2016-12-22","123","5000","Architecture fees paid to his wife account. 			
\n","","","","cheque","2989","ZAKIYA BEGUM");
INSERT INTO expenses VALUES("9139","1","","","2016-12-30","117","600","Nadeem bhai have food in shan Bagh		
\n","","","","bank transfer","","SHANBHAGS");
INSERT INTO expenses VALUES("9140","1","","","2016-12-30","119","200","VPS/IOCL AMAR S/20161230130433/0","","","","cash",""," AMAR");
INSERT INTO expenses VALUES("9141","1","","","2016-11-18","118","169","Cash dep Chg Oct-16			
\n","","","","cash","","Bankers");
INSERT INTO expenses VALUES("9143","1","","","2016-11-22","119","1813","Nadeem bhai purchase from Balaji Grand.","","","","bank transfer","","BALAJI GRAND ");
INSERT INTO expenses VALUES("9144","1","","","2016-12-31","117","525","VPS/GRAND HOTEL/20161231231559/0			
\n","","","","bank transfer","","GRAND HOTEL");
INSERT INTO expenses VALUES("9145","1","","","2017-05-16","1","50000","CASH PAID:VENKAT	","","","","cheque","3109","VENKATESH");
INSERT INTO expenses VALUES("9146","1","","","2017-06-03","1","24000","CASH PAID:VENKATESH
\n","","","","cheque","3121","VENKATESH");
INSERT INTO expenses VALUES("9147","1","","","2017-06-23","1","30000","CASH PAID:VENKATH
\n","","","","cheque","3143","VENKATESH");
INSERT INTO expenses VALUES("9148","1","","","2017-06-29","1","4500","Paid to MALLE VENKATESHWARLU","","","","cheque","3203","VENKATESH");
INSERT INTO expenses VALUES("9149","1","","","2017-06-30","1","73000","NEFT:000028929800/MALLE VENKATESHWARLU","","","","cheque","3148","VENKATESH");
INSERT INTO expenses VALUES("9150","1","","","2017-06-03","116","49000","CASH PAID:SHABBER AHMED	
\n","","","","cheque","3195","Shabbir");
INSERT INTO expenses VALUES("9151","1","","","2017-06-06","116","54291","CASH PAID:AHMED
\n","","","","cheque","3196","Shabbir");
INSERT INTO expenses VALUES("9152","1","","","2017-06-09","116","15000","CASH PAID:SHABBIR AHMED
\n","","","","cheque","3122","Shabbir");
INSERT INTO expenses VALUES("9153","1","","","2017-06-15","116","30000","CASH PAID:SHABBIR AHMED	","","","","cheque","3135","Shabbir");
INSERT INTO expenses VALUES("9154","1","","","2017-06-29","116","50000","Cash paid: SHABBIR AHMED	
\n","","","","cheque","3147","Shabbir");
INSERT INTO expenses VALUES("9155","1","","","2017-06-12","116","2300","CASH PAID:AHMED	
\n","","","","cheque","3127","Shabbir");
INSERT INTO expenses VALUES("9157","1","","","2017-05-18","118","115","Chq book Chg Apr-17 + S Tax15.00
\n","","","","cash","","Bankers");
INSERT INTO expenses VALUES("9159","1","","","2017-05-22","115","558","Land line phone bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9160","1","","","2017-06-03","95","15292","Paid electricity bill
\n","","","","cheque","3194","Electricity bill ");
INSERT INTO expenses VALUES("9161","1","","","2017-06-13","14","64000","Transfer to NALLA VERRIYYA","","","","cheque","3125","Babu");
INSERT INTO expenses VALUES("9162","1","","","2017-06-03","2","60000","NEFT:000027709393/INDIA STEEL ENTERPRISES","","","","cheque","3116","JUNAID");
INSERT INTO expenses VALUES("9163","1","","","2016-12-19","123","50000","Amount paid for architecture drawing. Amount transfer nto his wife account TRFR TO:MUBEEM SHAREEF.","","","","cheque","2988","Waffi");
INSERT INTO expenses VALUES("9164","1","","","2016-12-22","123","50000","Amount paid for architecture drawing. Amount transfer nto his wife account TRFR TO:MUBEEM SHAREEF.","","","","cheque","2987","Waffi");
INSERT INTO expenses VALUES("9165","1","","","2016-12-22","119","18800","Dont remember 			
\n","","","","cheque","2991","RAGHUNATHA REDDY");
INSERT INTO expenses VALUES("9166","1","","","2016-12-28","119","2000","Dont remember.","","","","bank transfer","","SRI ANJA");
INSERT INTO expenses VALUES("9167","1","","","2016-12-29","119","25000","LRS fees paid for 2 plots","","","","cheque","2995","Ansari");
INSERT INTO expenses VALUES("9168","1","","","2016-12-31","111","650","Internet bill paid","","","","cheque","2997","COUNTRY ONLINE ");
INSERT INTO expenses VALUES("9169","1","","","2017-01-02","117","2165","Nadeem bhai purchase. total 3 entries in statement. we put one entry.","","","","bank transfer","","Purchase");
INSERT INTO expenses VALUES("9170","1","","","2017-01-03","117","6500","Total 4 entries in statement.","","","","bank transfer","","Purchase");
INSERT INTO expenses VALUES("9171","1","","","2017-01-05","117","17236","Total 3 entries in statement.","","","","bank transfer","","Purchase");
INSERT INTO expenses VALUES("9172","1","","","2017-06-17","2","40000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3139","JUNAID");
INSERT INTO expenses VALUES("9173","1","","","2017-06-28","2","18600","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3144","JUNAID");
INSERT INTO expenses VALUES("9174","1","","","2017-05-20","9","30000","CASH PAID:SENU","","","","cheque","3110","Senu");
INSERT INTO expenses VALUES("9175","1","","","2017-06-03","9","50000","CASH PAID:SENU		
\n","","","","cheque","3118","Senu");
INSERT INTO expenses VALUES("9176","1","","","2017-06-05","119","650","Internet bill paid.","","","","cheque","3197","Country online");
INSERT INTO expenses VALUES("9177","1","","","2017-06-13","117","8000","CASH PAID:NADEEM","","","","cheque","3131","Nadeem bhai");
INSERT INTO expenses VALUES("9178","1","","","2017-06-13","119","6000","APLINES BOREWELLS AND PUM","","","","cheque","3192","Borewell & Pump");
INSERT INTO expenses VALUES("9179","1","","","2017-04-12","2","52800","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3079","JUNAID");
INSERT INTO expenses VALUES("9180","1","","","2017-05-02","2","62400","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3092","JUNAID");
INSERT INTO expenses VALUES("9181","1","","","2017-05-11","2","63000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3106","JUNAID");
INSERT INTO expenses VALUES("9182","1","","","2017-05-03","114","120300","Purchase steel from H S M STEELS.","","","","cheque","3090","KESHREE METAL");
INSERT INTO expenses VALUES("9185","1","","","2017-04-29","1","50000","CASH PAID:VENKATH","","","","cheque","3088","VENKATESH");
INSERT INTO expenses VALUES("9186","1","","","2017-05-06","1","40000","Paid to: VENKATESH","","","","cheque","3096","VENKATESH");
INSERT INTO expenses VALUES("9187","1","","","2017-05-01","14","95400","Paid to VERRIYYA NALLA","","","","cheque","3082","Babu");
INSERT INTO expenses VALUES("9188","1","","","2017-02-08","119","5000","Cheque issued: Self","","","","cheque","3018","SELF");
INSERT INTO expenses VALUES("9189","1","","","2017-02-10","119","125000","Cheque issued: Self","","","","cheque","3021","SELF");
INSERT INTO expenses VALUES("9190","1","","","2017-02-10","119","200000","Cheque issued: Self","","","","cheque","3023","SELF");
INSERT INTO expenses VALUES("9191","1","","","2017-02-10","119","10000","Cheque issued: Self","","","","cheque","3022","SELF");
INSERT INTO expenses VALUES("9192","1","","","2017-02-13","119","24000","ATM/CASH WDL/11-02-17/0","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9193","1","","","2017-02-14","119","400000","Cheque issued: Self","","","","cheque","3025","SELF");
INSERT INTO expenses VALUES("9194","1","","","2017-02-18","119","50000","Cheque issued: Self","","","","cheque","3027","SELF");
INSERT INTO expenses VALUES("9195","1","","","2017-02-18","119","50000","Cheque issued: Self","","","","cheque","3029","SELF");
INSERT INTO expenses VALUES("9196","1","","","2017-02-22","119","30000","Cheque issued: Self","","","","cheque","3035","SELF");
INSERT INTO expenses VALUES("9197","1","","","2017-03-10","119","75000","Cheque issued: Self","","","","cheque","3050","SELF");
INSERT INTO expenses VALUES("9198","1","","","2017-03-14","119","15000","Cheque issued: Self","","","","cheque","3053","SELF");
INSERT INTO expenses VALUES("9199","1","","","2017-03-03","119","25000","Cheque issued: Self","","","","cheque","3046","SELF");
INSERT INTO expenses VALUES("9200","1","","","2017-03-04","119","25000","TRFR TO:MOHD AZEEMUDDIN QURAISHI","","","","cheque","3041","SELF");
INSERT INTO expenses VALUES("9201","1","","","2017-01-02","119","1289","	VPS/QUALITY CAR/20170102115437/0	","","","","bank transfer","","QUALITY CAR");
INSERT INTO expenses VALUES("9202","1","","","2017-01-03","119","2000","VPS/PRASADS IMA/20170103193732/0	","","","","bank transfer","","PRASADS IMA");
INSERT INTO expenses VALUES("9203","1","","","2017-01-10","119","1233","VPS/QUALITY CAR","","","","bank transfer","","QUALITY CAR");
INSERT INTO expenses VALUES("9204","1","","","2017-02-10","120","10000","Salary paid to superviser","","","","cheque","3020","Kishore");
INSERT INTO expenses VALUES("9205","1","","","2017-03-06","120","15000","Paid salary","","","","cheque","3044","Kishore");
INSERT INTO expenses VALUES("9206","1","","","2017-02-18","119","50000","Hand loan return to Alam","","","","cheque","3030","Alam");
INSERT INTO expenses VALUES("9207","1","","","2017-02-24","119","10000","xxx","","","","cheque","3033","ABDUL HAKEEM");
INSERT INTO expenses VALUES("9208","1","","","2017-03-04","119","45000","xxx","","","","cheque","3040","ALEEM");
INSERT INTO expenses VALUES("9209","1","","","2017-03-17","119","10000","Hand loan given","","","","cheque","3057","Afzal");
INSERT INTO expenses VALUES("9210","1","","","2017-03-21","119","10000","Amount paid firm registration.","","","","cheque","3059","Balu");
INSERT INTO expenses VALUES("9211","1","","","2017-01-07","119","46000","Cheque issued: Self","","","","cheque","3000","SELF");
INSERT INTO expenses VALUES("9212","1","","","2017-01-10","119","20600","Cheque issued: Self","","","","cheque","3001","SELF");
INSERT INTO expenses VALUES("9213","1","","","2017-01-19","119","50000","Cheque issued: Self","","","","cheque","3003","SELF");
INSERT INTO expenses VALUES("9214","1","","","2017-01-20","119","4000","Cheque issued: Self","","","","cheque","3005","SELF");
INSERT INTO expenses VALUES("9215","1","","","2017-01-27","119","60000","	CASH PAID:SELF	3012	60,000.00	0.00				
\n","","","","cheque","3012","SELF");
INSERT INTO expenses VALUES("9216","1","","","2017-01-10","119","2206","VPS/CARE HOSPIT/20170110134641/0","","","","bank transfer","","CARE HOSPITAL");
INSERT INTO expenses VALUES("9217","1","","","2017-01-10","119","4284","VPS/KARACHI BAK/20170110151244/0	","","","","bank transfer","","KARACHI BAKERY");
INSERT INTO expenses VALUES("9218","1","","","2017-03-24","119","50000","Cheque issued: Self","","","","cheque","3066","SELF");
INSERT INTO expenses VALUES("9219","1","","","2017-03-24","119","30000","Cheque issued: Self","","","","cheque","3067","SELF");
INSERT INTO expenses VALUES("9220","1","","","2017-03-28","9","50000","Paid to: K SRINIVAS RAO","","","","cheque","3073","Senu");
INSERT INTO expenses VALUES("9221","1","","","2017-03-01","119","10023","NFS/CASH WDL/01-03-17","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9222","1","","","2017-03-01","119","10023","NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9223","1","","","2017-03-01","119","10023","NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9224","1","","","2017-03-01","119","10023","	NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9225","1","","","2017-03-01","119","6023","NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00		","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9226","1","","","2017-01-02","119","876","VPS/KARACHI BAK/20170102124207/0	","","","","bank transfer","","KARACHI BAKERY");
INSERT INTO expenses VALUES("9227","1","","","2017-01-03","119","40000","NFS/CASH WDL/03-01-17	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9228","1","","","2017-01-03","119","500","IPS/TOLICHOWKI /20170103224410/0	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9229","1","","","2017-01-05","119","16404","VPS/Brand Facto/20170105143232/0","","","","bank transfer","","Brand Factory");
INSERT INTO expenses VALUES("9230","1","","","2017-01-05","119","211","VPS/DHYANSAI FO/20170105232412/0	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9231","1","","","2017-01-06","119","650","VPS/SHAH GHOUSE/20170107031708/0","","","","bank transfer","","SHAH GHOUSE");
INSERT INTO expenses VALUES("9232","1","","","2017-01-09","119","100","VPS/TOLICHOWKI /20170109124057/0","","","","bank transfer","","VPS/TOLICHOWKI");
INSERT INTO expenses VALUES("9233","1","","","2017-01-09","119","1000","Transfer to SRI MAHALAK","","","","bank transfer","","SRI MAHALAK");
INSERT INTO expenses VALUES("9234","1","","","2017-01-11","119","2023","NFS/CASH WDL/11-01-17/Fee Rs20.00 ST Rs3.00		","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9235","1","","","2017-01-12","119","760","VPS/SHANBHAG S /20170112170146/","","","","bank transfer","","SHANBHAG ");
INSERT INTO expenses VALUES("9236","1","","","2017-01-02","119","37700","Paid to: S R CONSTRUCTION","","","","cheque","2996","S R CONSTRUCTION");
INSERT INTO expenses VALUES("9237","1","","","2016-05-28","9","250000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9238","1","","","2016-06-08","9","25000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9239","1","","","2016-06-11","9","130000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9240","1","","","2016-06-22","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9241","1","","","2016-06-25","9","20000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9242","1","","","2016-07-15","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9243","1","","","2016-07-19","9","130000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9244","1","","","2016-07-26","9","120000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9245","1","","","2016-08-04","9","150000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9246","1","","","2016-08-15","9","135000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9247","1","","","2016-08-27","9","130000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9248","1","","","2016-09-05","9","250000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9249","1","","","2016-09-17","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9250","1","","","2016-09-21","9","200000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9251","1","","","2016-10-07","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9252","1","","","2016-10-08","9","150000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9253","1","","","2016-10-26","9","250000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9254","1","","","2016-11-08","9","50000","Paid labour payment","","","","cash","","sen");
INSERT INTO expenses VALUES("9255","1","","","2016-11-14","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9256","1","","","2016-12-16","9","25000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9257","1","","","2016-12-31","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9258","1","","","2017-03-27","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9259","1","","","2017-05-24","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9260","1","","","2017-05-03","9","50000","Paid labour payment","","","","cheque","3092","Senu");
INSERT INTO expenses VALUES("9261","1","","","2017-05-11","9","50000","Paid labour payment","","","","cheque","3105","Senu");
INSERT INTO expenses VALUES("9262","1","","","2017-05-22","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9263","1","","","2017-06-06","9","10000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9264","1","","","2017-06-14","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9265","1","","","2017-05-12","119","20000","Cheque paid: Self","","","","cheque","3087","SELF");
INSERT INTO expenses VALUES("9266","1","","","2017-05-18","119","8000","Cheque paid: Self","","","","cheque","3107","SELF");
INSERT INTO expenses VALUES("9267","1","","","2017-05-26","119","50000","Cheque paid: Azeem","","","","cheque","3113","SELF");
INSERT INTO expenses VALUES("9268","1","","","2017-06-03","119","25000","TRFR TO:M AZEEMUDDIN QURAISHI","","","","cheque","3115","SELF");
INSERT INTO expenses VALUES("9269","1","","","2017-06-09","119","100000","Cheque paid: Self","","","","cheque","3123","SELF");
INSERT INTO expenses VALUES("9270","1","","","2017-05-04","77","4000","Purchase electrical material from MUKESH ELECTRICALS","","","","cheque","3191","DEVA");
INSERT INTO expenses VALUES("9271","1","","","2017-04-12","5","88184","Purchase sanitary material from SRI LAXMI SALES CORPORATI	","","","","cheque","3078","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9272","1","","","2017-05-01","14","95400","Transfer to: VERRIYYA NALLA","","","","cheque","3082","Babu");
INSERT INTO expenses VALUES("9273","1","","","2017-05-10","14","62040","Transfer to: NALLA VERRIYYA	","","","","cheque","3100","Babu");
INSERT INTO expenses VALUES("9274","1","","","2017-05-08","115","511","Land line phone bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9275","1","","","2017-04-07","119","25000","TRFR TO:M AZEEMUDDIN QURAISHI","","","","cheque","3077","SELF");
INSERT INTO expenses VALUES("9276","1","","","2017-05-03","119","25000","Cheque paid to: Self","","","","cheque","3093","SELF");
INSERT INTO expenses VALUES("9277","1","","","2017-05-06","119","50000","Cheque paid to: Self. ","","","","cheque","3099","SELF");
INSERT INTO expenses VALUES("9278","1","","","2017-05-09","119","100000","Cheque paid to: Self.","","","","cheque","3101","SELF");
INSERT INTO expenses VALUES("9279","1","","","2017-05-11","119","25000","Cheque paid to: YASMEEN AFROZE","","","","cheque","3103","YASMEEN AFROZE");
INSERT INTO expenses VALUES("9280","1","","","2017-05-06","119","25000","TRFR TO:AZEEMUDDIN QUADRI","","","","cheque","3098","SELF");
INSERT INTO expenses VALUES("9281","1","","","2017-04-11","114","144963","Purchase steels from KESHREE METALURGIES P LTD","","","","cheque","3076","KESHREE METAL");
INSERT INTO expenses VALUES("9282","1","","","2017-06-13","5","5846","TRFR TO:J K SANITARY AND ELECTRICAL","","","","cheque","3199"," J K SANITARY AND ELECTRICAL");
INSERT INTO expenses VALUES("9283","1","","","2017-06-21","5","4300","TRFR TO:J K SANITARY & ELECTRICAL","","","","cheque","3201","J K SANITARY & ELECTRICAL");
INSERT INTO expenses VALUES("9284","1","","","2017-07-26","102","250000","TRFR TO:FZAMI ONLINE SERVICES","","","","cheque","3180","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9285","1","","","2017-07-04","116","40000","CASH PAID:SHABBIR AHMED","","","","cheque","3151","Shabbir");
INSERT INTO expenses VALUES("9286","1","","","2017-07-05","116","7000","Cheque paid to: SHABBBIR AHMED","","","","cheque","3152","Shabbir");
INSERT INTO expenses VALUES("9287","1","","","2017-07-07","114","100000","Purchase steels from H S M STEELS","","","","cheque","3153","H S M STEELS");
INSERT INTO expenses VALUES("9288","1","","","2017-07-12","2","58000","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3161","JUNAID");
INSERT INTO expenses VALUES("9289","1","","","2017-07-21","2","57000","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3173","JUNAID");
INSERT INTO expenses VALUES("9290","1","","","2017-06-12","121","30000","Purchase lappum from company.","","","","cheque","3114","ALLTEK SECCOLOR");
INSERT INTO expenses VALUES("9291","1","","","2017-06-12","120","9500","Salary paid to Ramesh","","","","cheque","3128","Ramesh");
INSERT INTO expenses VALUES("9292","1","","","2017-07-03","14","129000","Paid to: NALLA  VERRIYYA ","","","","cheque","3207","Babu");
INSERT INTO expenses VALUES("9293","1","","","2017-07-25","14","100000","Paid to: NALLA VERRIYYA 	","","","","cheque","3177","Babu");
INSERT INTO expenses VALUES("9294","1","","","2017-07-03","115","513","Land line phone bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9295","1","","","2017-07-17","115","535","Land line phone bill paid.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9296","1","","","2017-07-06","95","19889","Paid Electricity bill.","","","","cheque","3206","Electricity bill ");
INSERT INTO expenses VALUES("9297","1","","","2017-07-18","95","11009","Paid Electricity bill ","","","","cheque","3163","Electricity bill ");
INSERT INTO expenses VALUES("9298","1","","","2017-07-11","1","30000","Paid to 	VENKATESH	
\n","","","","cheque","3157","VENKATESH");
INSERT INTO expenses VALUES("9299","1","","","2017-07-15","1","50000","Paid to VENKATESH. ","","","","cheque","3172","VENKATESH");
INSERT INTO expenses VALUES("9300","1","","","2017-07-25","1","40000","CHEQUE PAID:M VENKATHWARLU	","","","","cheque","3178","VENKATESH");
INSERT INTO expenses VALUES("9301","1","","","2017-07-11","119","25000","TRFR TO:M AZEEMUDDIN QURASHI	","","","","cheque","3158","SELF");
INSERT INTO expenses VALUES("9302","1","","","2017-07-13","119","75000","Cheque paid to: Self","","","","cheque","3162","SELF");
INSERT INTO expenses VALUES("9303","1","","","2017-07-03","77","25200","Purchase Electrical material from MUKESH ELECTRICALS","","","","cheque","3149","DEVA");
INSERT INTO expenses VALUES("9304","1","","","2017-07-15","120","9500","Salary paid to Ramesh","","","","bank transfer","","Ramesh");
INSERT INTO expenses VALUES("9305","1","","","2017-07-26","119","909","Transfer to KARACHI BAKERY","","","","bank transfer","","KARACHI BAKERY");
INSERT INTO expenses VALUES("9306","1","","","2017-07-27","119","20000","Cheque paid to: Self.","","","","cheque","3182","SELF");
INSERT INTO expenses VALUES("9307","1","","","2017-07-28","119","25000","Cheque paid to: Self.","","","","cheque","3184","SELF");
INSERT INTO expenses VALUES("9308","1","","","2017-07-29","119","60000","Cheque paid to: Self.","","","","cheque","3185","SELF");
INSERT INTO expenses VALUES("9309","1","","","2017-08-02","119","25000","TRFR TO:M AZEEMUDDIN QURAISHI","","","","cheque","3190","SELF");
INSERT INTO expenses VALUES("9310","1","","","2017-08-11","119","10000","Cheque issued: Self.","","","","cheque","3218","SELF");
INSERT INTO expenses VALUES("9311","1","","","2017-08-24","119","34000","Cheque issued: Self.","","","","cheque","3232","SELF");
INSERT INTO expenses VALUES("9312","1","","","2017-08-28","119","100000","Cheque issued: Self.","","","","cheque","3236","SELF");
INSERT INTO expenses VALUES("9313","1","","","2017-09-22","119","100000","TRFR TO: FZAMI ONLINE SERVICES","","","","cheque","3291","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9314","1","","","2017-09-19","10","25000","PAID TO: TIRUPATHI SWAMY","","","","cheque","3254","Trupatty");
INSERT INTO expenses VALUES("9315","1","","","2017-09-04","95","8176","Paid Electricity bill.","","","","cheque","3243","Electricity bill ");
INSERT INTO expenses VALUES("9316","1","","","2017-09-06","115","1384","Paid Land line bill (2 entries in one time done).","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9317","1","","","2017-09-22","115","1368","Paid Land line phone bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9318","1","","","2017-08-03","1","45000","Transfer to:  VENKATESH       
\n","","","","cheque","3186","VENKATESH");
INSERT INTO expenses VALUES("9319","1","","","2017-08-11","1","46000","CHEQUE PAID:VENKETESHWARLU.","","","","cheque","3213","VENKATESH");
INSERT INTO expenses VALUES("9320","1","","","2017-09-12","1","44344","Transfer to: Venkatesh.","","","","cheque","3246","VENKATESH");
INSERT INTO expenses VALUES("9321","1","","","2017-09-12","1","56000","CHEQUE  PAID:Venkatesh","","","","cheque","3247","VENKATESH");
INSERT INTO expenses VALUES("9322","1","","","2017-08-08","114","100000","Paid to: H S M STEELS","","","","cheque","3210","H S M STEELS");
INSERT INTO expenses VALUES("9323","1","","","2017-08-09","2","55000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3211","JUNAID");
INSERT INTO expenses VALUES("9324","1","","","2017-08-29","2","53000","Purchase cement from INDIA STEEL ENTERPRISES.	","","","","cheque","3241","JUNAID");
INSERT INTO expenses VALUES("9325","1","","","2017-09-18","114","50000","Paid to: H S M STEELS","","","","cheque","3251","H S M STEELS");
INSERT INTO expenses VALUES("9326","1","","","2018-04-09","116","2950","Paid for door fitting charges.","","","","cheque","3499","Shabbir");
INSERT INTO expenses VALUES("9327","1","","","2018-04-09","5","28146","Paid amount towards purchase of material.","","","","cheque","3498","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9328","1","","","2017-07-27","111","1300","Internet bill paid","","","","cheque","3181","Country online");
INSERT INTO expenses VALUES("9329","1","","","2017-04-12","119","20000","Paid for electricity meter.","","","","cheque","3075","Aleem");
INSERT INTO expenses VALUES("9330","1","","","2017-05-03","9","50000","Paid to: Senu","","","","cheque","3094","Senu");
INSERT INTO expenses VALUES("9331","1","","","2017-05-11","9","50000","Cheque issued: Mahboob ","","","","cheque","3104","Senu");
INSERT INTO expenses VALUES("9332","1","","","2017-04-28","95","18348","Paid  Electricity bill. ( AAO ERO A C GUARDS )","","","","cheque","3085","Electricity bill ");
INSERT INTO expenses VALUES("9333","1","","","2018-04-28","122","12000","Cash withdraw for Tirupathi. But used for purchase of robosand","","","","cheque","3084","Trupatty");
INSERT INTO expenses VALUES("9334","1","","","2017-06-13","98","7000","Dont remember.","","","","cheque","3134","Fazil");
INSERT INTO expenses VALUES("9335","1","","","2017-06-13","125","8000","For Staircase. Total amount is Rs 17000. Ballance Rs 9000.","","","","cheque","3133","Sajid");
INSERT INTO expenses VALUES("9336","1","","","2017-06-13","98","3500","Paid to: Imran.","","","","cheque","3132","Imran");
INSERT INTO expenses VALUES("9337","1","","","2017-06-17","120","10000","Advance salary given.","","","","cheque","3137","Mahboob");
INSERT INTO expenses VALUES("9338","1","","","2017-06-28","119","19000","NEFT:000028800160/MUSTAFFA SIDDIQUI","","","","cheque","3145","Mustaffa siddiqui");
INSERT INTO expenses VALUES("9339","1","","","2017-06-29","98","3000","Paid to: Anand.","","","","cheque","3146","Anand");
INSERT INTO expenses VALUES("9340","1","","","2017-06-29","122","15000","TRFR TO:K TIRUPATHI SWAMY. for purchase of Robo Sand.","","","","cheque","3205","Trupatty");
INSERT INTO expenses VALUES("9341","1","","","2017-08-03","118","294","Dbt card Chg Jun-17.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9342","1","","","2017-08-02","117","30000","TRFR TO:NIZAMUDDIN QURESHI NADEEM","","","","cheque","3187","Nadeem bhai");
INSERT INTO expenses VALUES("9343","1","","","2017-08-17","98","11000","Paid to: A P LINES BORE WELL AND P.","","","","cheque","3212"," BORE WELL");
INSERT INTO expenses VALUES("9344","1","","","2017-08-18","14","100000","Paid to: VERRIYYA NALLA.","","","","cheque","3219","Babu");
INSERT INTO expenses VALUES("9345","1","","","2017-08-24","5","112215","Purchase sanitary material from SRI LAXMI SALES CORPORAT.","","","","cheque","3228","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9346","1","","","2017-08-30","77","30500","Purchase electrical material from Mukesh electricals.","","","","cheque","3244","DEVA");
INSERT INTO expenses VALUES("9347","1","","","2017-09-19","77","68000","Purchase electrical material from Mukesh electricals.","","","","cheque","3255","DEVA");
INSERT INTO expenses VALUES("9348","1","","","2018-04-24","2","25500","Cement purchase and hamali paid. NEFT:000044423204/INDIA STEEL ENTERPRISES	","","","","cheque","3503","Junaid");
INSERT INTO expenses VALUES("9349","1","","","2018-04-24","5","36000","Sanatary purchase.	TRFR TO: J K SANITARY & ELECTRICAL
\n","","","","bank transfer","","J K SANITARY");
INSERT INTO expenses VALUES("9350","1","","","2018-04-24","1","21000","Sand purchase and amount paid. TRFR TO: MALLE VENKATESHWARLU","","","","cheque","3501","VENKATESH");
INSERT INTO expenses VALUES("9351","1","","","2018-04-19","1","25000","Sand purchase. TRFR TO:M VENKATSWARLAU.","","","","cheque","3612","VENKATESH");
INSERT INTO expenses VALUES("9352","1","","","2018-04-17","5","30000","Sanatary purchase. TRFR TO:J K SAINTARY	
\n","","","","cheque","3611","J K SAINTARY");
INSERT INTO expenses VALUES("9353","1","","","2018-04-16","95","17121","Paid Electricity bill. TSSPDCL","","","","cheque","3608","Electricity bill ");
INSERT INTO expenses VALUES("9354","1","","","2018-04-13","120","9500","Salary paid. CASH PAID:RAMESH","","","","cheque","3609","Ramesh");
INSERT INTO expenses VALUES("9355","1","","","2018-04-10","123","15000","Amount paid for 3D design for broucher. TRFR TO: PEDDABOINA TIRUPATHI	","","","","cheque","3607","Tirupathi");
INSERT INTO expenses VALUES("9356","1","","","2018-04-09","1","50000","Sand purchase. TRFR TO:M VENKATESWARLU.","","","","cheque","3605","VENKATESH");
INSERT INTO expenses VALUES("9357","1","","","2018-04-07","77","11500","Electrical material purchase by yousuf .CASH PAID:mukesh	
\n","","","","cheque","3604","Yousuf");
INSERT INTO expenses VALUES("9358","1","","","2017-08-17","120","10000","Salary paid to: Ramesh.","","","","cheque","3222","Ramesh");
INSERT INTO expenses VALUES("9359","1","","","2017-09-29","77","3400","Purchase electrical material from Mukesh electricals.","","","","cheque","3260","DEVA");
INSERT INTO expenses VALUES("9360","1","","","2017-09-29","120","5000","CASH PAID:Ramesh	","","","","cheque","3265","Ramesh");
INSERT INTO expenses VALUES("9361","1","","","2017-10-07","2","53000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3270","JUNAID");
INSERT INTO expenses VALUES("9362","1","","","2017-10-11","114","65000","Purchase steels from H S M STEELS.","","","","cheque","3276","H S M STEELS");
INSERT INTO expenses VALUES("9363","1","","","2017-10-13","77","100000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3277","DEVA");
INSERT INTO expenses VALUES("9364","1","","","2017-10-03","77","35000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3266","DEVA");
INSERT INTO expenses VALUES("9365","1","","","2017-10-16","77","41000","Purchase electrical material from Mukesh electricals.","","","","cheque","3279","DEVA");
INSERT INTO expenses VALUES("9366","1","","","2017-10-26","77","53800","Purchase electrical material from Mukesh electricals.","","","","cheque","3290","DEVA");
INSERT INTO expenses VALUES("9367","1","","","2017-08-11","89","5000","Paid weekly labour payment.","","","","cheque","3215","Ibrahim");
INSERT INTO expenses VALUES("9368","1","","","2017-09-01","89","10000","Paid weekly labour payment","","","","cheque","3233","Ibrahim");
INSERT INTO expenses VALUES("9369","1","","","2017-10-21","1","30000","TRFR TO:MALLE VENKATESHWARLU","","","","cheque","3288","VENKATESH");
INSERT INTO expenses VALUES("9370","1","","","2017-10-05","14","50000","Paid to: VERRIYYA NALLA.","","","","cheque","3267","Babu");
INSERT INTO expenses VALUES("9371","1","","","2017-10-26","119","11688","Cheque issued: Self.","","","","cheque","3298","SELF");
INSERT INTO expenses VALUES("9372","1","","","2017-10-04","119","20000","Cheque issued: Self.","","","","cheque","3268","SELF");
INSERT INTO expenses VALUES("9373","1","","","2017-10-04","95","6965","Paid electricity bill.","","","","cheque","3258","Electricity bill ");
INSERT INTO expenses VALUES("9374","1","","","2017-10-25","121","47250","Purchase lappum from ALLTEK SECCOLOR.","","","","cheque","3301","ALLTEK SECCOLOR");
INSERT INTO expenses VALUES("9375","1","","","2017-10-13","120","5000","Paid to: Ramesh.","","","","cheque","3296","Ramesh");
INSERT INTO expenses VALUES("9376","1","","","2017-11-15","115","618","Paid Land line phone bill. (2 entries in one time done)","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9377","1","","","2018-11-02","95","12215","Paid electricity bill.","","","","cheque","3308","Electricity bill ");
INSERT INTO expenses VALUES("9378","1","","","2017-11-17","95","5981","Paid electricity bill.","","","","cheque","3333","Electricity bill ");
INSERT INTO expenses VALUES("9379","1","","","2017-11-15","77","41500","Purchase electrical material from Mukesh eletricals.","","","","cheque","3338","DEVA");
INSERT INTO expenses VALUES("9380","1","","","2017-11-17","77","16430","Purchase electrical material from Mukesh eletricals.","","","","cheque","3339","DEVA");
INSERT INTO expenses VALUES("9381","1","","","2017-11-30","77","3600","Purchase electrical material from Mukesh eletricals.","","","","cheque","3349","DEVA");
INSERT INTO expenses VALUES("9382","1","","","2017-09-29","116","10000","Paid to: Shabbir Ahmed.","","","","cheque","3264","Shabbir");
INSERT INTO expenses VALUES("9383","1","","","2017-10-31","2","52500","Purchase steel from INDIA STEEL ENTERPRISES.","","","","cheque","3309","JUNAID");
INSERT INTO expenses VALUES("9384","1","","","2017-12-15","2","101450","Purchase steel from INDIA STEEL ENTERPRISES.","","","","cheque","3366","JUNAID");
INSERT INTO expenses VALUES("9385","1","","","2017-10-31","1","30000","Sand purchase  amt. TRFR TO:MALLE VENKATESHWARLU.","","","","cheque","3314","VENKATESH");
INSERT INTO expenses VALUES("9386","1","","","2017-12-07","1","10000","Sand purchase  amt. TRFR TO:MALLE VENKATESHWARLU.","","","","cheque","3359","VENKATESH");
INSERT INTO expenses VALUES("9387","1","","","2017-10-31","89","10000","Flat waterproofing + Muradnagar work done.","","","","cheque","3312","Ibrahim");
INSERT INTO expenses VALUES("9388","1","","","2017-10-30","119","25000","Paid to ULTRA DENTAL HOSPITAL.","","","","cheque","3282","ULTRA DENTAL HOSPITAL.");
INSERT INTO expenses VALUES("9389","1","","","2017-11-21","119","145000","Cheque issued on Self.","","","","cheque","3342","SELF");
INSERT INTO expenses VALUES("9390","1","","","2017-11-29","119","20000","Cheque issued: Self.","","","","cheque","3347","SELF");
INSERT INTO expenses VALUES("9391","1","","","2017-11-01","5","94230","Purchase sanitary material from SRI LAXMI SALES CORPORAT.","","","","cheque","3307","SRI LAXMI SALES CORPORAT");
INSERT INTO expenses VALUES("9392","1","","","2017-12-01","5","30454","Purchase sanitary material from SRI LAXMI SALES CORPORAT.","","","","cheque","3344","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9393","1","","","2017-12-06","116","30000","PAID:SHABBIR AHMED.","","","","cheque","3356","Shabbir");
INSERT INTO expenses VALUES("9394","1","","","2017-12-04","120","9500","Late salary paid November in december.","","","","cheque","3334","Ramesh");
INSERT INTO expenses VALUES("9395","1","","","2017-12-04","120","10000","Paid to: Ramesh.","","","","cheque","3355","Ramesh");
INSERT INTO expenses VALUES("9396","1","","","2017-11-07","5","4000","Purchase sanitary material from  J K SANITARY.","","","","cheque","3320","J K SANITARY");
INSERT INTO expenses VALUES("9397","1","","","2017-10-31","9","20000","Paid weekly labour payment.","","","","cheque","3313","Senu");
INSERT INTO expenses VALUES("9398","1","","","2017-11-10","120","4000","Salary paid to Mahboob.","","","","cheque","3326","Mahboob");
INSERT INTO expenses VALUES("9399","1","","","2017-10-31","120","8000","Salary paid to Amair.","","","","cheque","3310","Amair");
INSERT INTO expenses VALUES("9400","1","","","2017-11-30","120","8000","Salary paid to Amair.","","","","cheque","3350","Amair");
INSERT INTO expenses VALUES("9401","1","","","2017-12-08","120","5000","Paid to: Mahboob.","","","","cheque","3360","Mahboob");
INSERT INTO expenses VALUES("9402","1","","","2017-11-08","102","150000","TRFR TO: FZAMI ONLINE SERVICES.","","","","cheque","3323"," FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9403","1","","","2017-11-15","102","50000","TRFR TO: FZAMI ONLINE SERVICES.","","","","cheque","3335","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9404","1","","","2017-11-09","14","55000","Paid to: VERRIYYA NALLA.","","","","cheque","3315","Babu");
INSERT INTO expenses VALUES("9405","1","","","2017-12-26","1","30901","TRFR TO:M VENKATESHWARLU	.","","","","cheque","3371","VENKATESH");
INSERT INTO expenses VALUES("9406","1","","","2017-12-26","1","35753","TRFR TO:M VENKATESHWARLU.","","","","cheque","3370","VENKATESH");
INSERT INTO expenses VALUES("9407","1","","","2017-12-26","95","7403","Paid electricity bill.","","","","cheque","3367","Electricity bill ");
INSERT INTO expenses VALUES("9409","1","","","2018-01-03","77","100000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3373","DEVA");
INSERT INTO expenses VALUES("9410","1","","","2018-01-12","77","50000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3390","DEVA");
INSERT INTO expenses VALUES("9411","1","","","2018-01-10","119","10000","Cheque issued: Self.","","","","cheque","3379","SELF");
INSERT INTO expenses VALUES("9412","1","","","2018-01-17","5","6100","Purchase sanitary material from  J K SANITARY.","","","","cheque","3391","J K SANITARY");
INSERT INTO expenses VALUES("9413","1","","","2018-01-20","95","5730","Paid electricity bill.","","","","cheque","3392","Electricity bill ");
INSERT INTO expenses VALUES("9414","1","","","2018-02-01","120","5000","Paid salary to Mahboob.","","","","cheque","3484","Mahboob");
INSERT INTO expenses VALUES("9415","1","","","2018-02-06","1","20000","Paid part payment to VENKATESHWARLU.","","","","cheque","3416","VENKATESH");
INSERT INTO expenses VALUES("9416","1","","","2018-02-06","2","54600","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3417","JUNAID");
INSERT INTO expenses VALUES("9417","1","","","2018-02-07","5","8243","Purchase sanitary material from  J K SANITARY & ELECTRICAL.	
\n
\n","","","","cheque","3418","J K SANITARY");
INSERT INTO expenses VALUES("9418","1","","","2018-02-07","121","47250","Purchase lappum from ALLTEK SECCOLOR.","","","","cheque","3414","ALLTEK SECCOLOR");
INSERT INTO expenses VALUES("9419","1","","","2018-02-09","120","10000","Salary paid to Ramesh.","","","","cheque","3423","Ramesh");
INSERT INTO expenses VALUES("9420","1","","","2018-02-17","9","30000","Paid weekly labour payment.","","","","cheque","3435","Senu");
INSERT INTO expenses VALUES("9421","1","","","2018-02-17","119","25000","Cheque issued on Self.","","","","cheque","3475","Azeemuddin Quraishi");
INSERT INTO expenses VALUES("9422","1","","","2018-01-10","77","274312","Paid DD for Transformer new meter.","","","","cheque","3380","TSSPDCL");
INSERT INTO expenses VALUES("9423","1","","","2018-01-10","119","10000","Paid to: Shiva.","","","","cheque","3382","Shiva");
INSERT INTO expenses VALUES("9424","1","","","2018-01-20","9","20000","Amount paid for sendrying work.","","","","cheque","3398","Ahmed Basha");
INSERT INTO expenses VALUES("9427","1","","","2018-01-30","119","14000","Paid to: Afzal.","","","","cheque","3407","Afzal");
INSERT INTO expenses VALUES("9428","1","","","2018-01-29","119","10000","Withdraw Amt. for Yousuf  but used for other expenditure.","","","","cheque","3489","Yousuf");
INSERT INTO expenses VALUES("9429","1","","","2018-02-03","122","18300","Purchase powder 3 lorries. ","","","","cheque","3412","Ravi");
INSERT INTO expenses VALUES("9430","1","","","2018-02-02","103","50000","Tiles purchase from Patel.","","","","cheque","3482","Patel");
INSERT INTO expenses VALUES("9431","1","","","2018-02-16","103","5000","Tiles purchase from Patel.","","","","cheque","3431","Patel");
INSERT INTO expenses VALUES("9432","1","","","2018-02-16","103","4500","Tiles purchase from Patel.","","","","cheque","3433","Patel");
INSERT INTO expenses VALUES("9433","1","","","2018-02-09","14","17000","Purchase RED BRICKS from Basith.","","","","cheque","3422","Basith");
INSERT INTO expenses VALUES("9434","1","","","2018-02-14","98","10000","Paid for material shifting.","","","","cheque","2429","Trupatty");
INSERT INTO expenses VALUES("9435","1","","","2018-02-09","121","9000","Paint material purchase.","","","","cheque","3421","Afsar");
INSERT INTO expenses VALUES("9436","1","","","2018-02-12","122","7500","Purchase ROBO SAND from Ravi.","","","","cheque","3426","Ravi");
INSERT INTO expenses VALUES("9437","1","","","2018-02-03","12","4000","Paid to Krishna","","","","cheque","3411","Krishna");
INSERT INTO expenses VALUES("9438","1","","","2018-02-05","13","4000","Material lifting charges.","","","","cheque","3415","Aqtar labour");
INSERT INTO expenses VALUES("9439","1","","","2018-02-17","121","10000","Purchase paint material.","","","","cheque","3476","Afsar");
INSERT INTO expenses VALUES("9440","1","","","2018-02-19","103","10000","Tiles purchase from Patel.","","","","cheque","3474","Patel");
INSERT INTO expenses VALUES("9441","1","","","2018-02-26","122","13500","Purchase powder & kankar from Ravi.","","","","cheque","3469","Ravi");
INSERT INTO expenses VALUES("9442","1","","","2018-02-26","9","22000","Paid labour payment.","","","","cheque","3465","Senu");
INSERT INTO expenses VALUES("9443","1","","","2018-02-27","5","38800","Purchase sanitary material from  J K SANITARY.","","","","cheque","3471","J K SANITARY");
INSERT INTO expenses VALUES("9444","1","","","2018-02-27","77","30000","Purchase electrical material from Mukesh Electricals.","","","","cheque","3462","DEVA");
INSERT INTO expenses VALUES("9445","1","","","2018-02-27","1","30000","TRFR TO: MALLE VENKATESHWARLU.","","","","cheque","3463","VENKATESH");
INSERT INTO expenses VALUES("9446","1","","","2018-02-28","119","50000","Amount return to Happy scholar.","","","","cheque","3453","Azeem sir");
INSERT INTO expenses VALUES("9447","1","","","2018-03-01","114","281600","Purchase steel from  H S M STEELS.","","","","cheque","3464","H S M STEELS");
INSERT INTO expenses VALUES("9450","1","","","2018-03-19","129","1003","Chq rtn Chg Feb-18+ GST.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9451","1","","","2018-03-01","114","281600","Purchase Steel from H S M STEELS.","","","","cheque","3464","H S M STEELS");
INSERT INTO expenses VALUES("9452","1","","","2018-03-23","2","52000","Purchase cement from INDIA STEEL ENTERPRISES.	","","","","cheque","3496","Junaid");
INSERT INTO expenses VALUES("9453","1","","","2018-03-01","129","85656","Paid to: NALLA VERRIYYA.	","","","","cheque","3460","Babu");
INSERT INTO expenses VALUES("9454","1","","","2018-03-02","129","60000","Purchase sanitary material from SRI LAKSHMI SALES CORPORATION.","","","","cheque","3450","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9455","1","","","2018-03-02","103","50000","Tiles purchase from Patel.","","","","cheque","3445","Patel");
INSERT INTO expenses VALUES("9456","1","","","2018-03-07","121","5000","Paint material purchase from Afsar.","","","","cheque","3594","Afsar");
INSERT INTO expenses VALUES("9457","1","","","2018-03-23","119","24000","Cheque issued on Azeem.","","","","cheque","3492","SELF");
INSERT INTO expenses VALUES("9458","1","","","2017-07-15","119","20000","Cheque issued on IFTEQAR UNNISA.","","","","cheque","3171","IFTEQAR UNNISA	");
INSERT INTO expenses VALUES("9459","1","","","2017-09-29","120","4800","Cheque paid to Amair.","","","","cheque","3262","Amair");
INSERT INTO expenses VALUES("9460","1","","","2017-10-21","121","7500","Paint material purchase from Afsar.","","","","cheque","3289","Afsar");
INSERT INTO expenses VALUES("9461","1","","","2017-10-20","121","10000","Purchase paint material .","","","","cheque","3281","Afsar");
INSERT INTO expenses VALUES("9462","1","","","2018-05-03","1","32500","TRFR TO: MALLE VENKATESHWARLU.	","","","","cheque","3615","VENKATESH");
INSERT INTO expenses VALUES("9463","1","","","2018-05-15","5","22643","Purchase sanitary material from  J K SANITARY.","","","","cheque","3640","J K SANITARY");
INSERT INTO expenses VALUES("9464","1","","","2018-05-16","5","50746","Purchase sanitary material from SRI LAXMI SALES CORPORAT.	","","","","cheque","3639","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9465","1","","","2018-05-23","5","30000","TRFR TO: J K SANITARY & ELECTRICAL.","","","","cheque","3633","J K SANITARY");
INSERT INTO expenses VALUES("9466","1","","","2018-05-22","2","45800","Purchase cement from  INDIA STEEL ENTERPRISES.","","","","cheque","3630","Junaid");
INSERT INTO expenses VALUES("9468","1","","","2018-05-11","120","10000","Salary paid to Ramesh for the month of April.","","","","cheque","3636","Ramesh");
INSERT INTO expenses VALUES("9469","1","","","2018-05-24","77","50100","Purchase electrical material from MUKESH ELECTRO VISION,","","","","cheque","3631","DEVA");
INSERT INTO expenses VALUES("9470","1","","","2018-05-11","10","15000","Rs 13000 paid by cheque & Rs 20000 paid by cash.","","","","cheque","3621","Trupatty");
INSERT INTO expenses VALUES("9471","1","","","2018-05-23","10","15000","Cash paid to Tirupathi.","","","","cheque","3629","Trupatty");
INSERT INTO expenses VALUES("9472","1","","","2018-05-07","103","30000","Purchase Tiles from Patel. ","","","","cheque","3506","Patel");
INSERT INTO expenses VALUES("9473","1","","","2018-05-11","97","6000","Cash paid to Mazher.","","","","cheque","3635","Mazher");
INSERT INTO expenses VALUES("9475","1","","","2018-05-02","110","200000","TRFR TO:REHAN SHAREEF.","","","","cheque","3613","Rehan Sharief");
INSERT INTO expenses VALUES("9476","1","","","2018-05-25","110","100000","TRFR TO: REHAN SHARIEF.","","","","cheque","3628","Rehan Sharief");
INSERT INTO expenses VALUES("9477","1","","","2018-05-11","95","43023","Electricity bill paid","","","","cheque","3620","TSSPDCL");
INSERT INTO expenses VALUES("9478","1","","","2018-05-16","77","1500","Exchange of meter. As old meter was burn.","","","","cheque","3634","TSSPDCL");
INSERT INTO expenses VALUES("9479","1","","","2018-05-11","104","15000","Cash withdraw Rs 20000 but Rs 5000 used for other expences. ","","","","cheque","3638","Kamal");
INSERT INTO expenses VALUES("9480","1","","","2018-05-07","123","15000","Paid for Brocher designing.","","","","cheque","3619","PEDDABOINA TIRUPATHI");
INSERT INTO expenses VALUES("9481","1","","","2018-05-05","104","10000","Rs 8000 by cheque & Rs 2000 by cash.","","","","cheque","3617","Kamal");
INSERT INTO expenses VALUES("9482","1","","","2018-05-05","113","30000","Purchase","","","","cheque","3618","Anil");
INSERT INTO expenses VALUES("9483","1","","","2017-07-15","98","2500","Paid to Pashu Ram.","","","","cheque","3167","Pashu Ram");
INSERT INTO expenses VALUES("9484","1","","","2017-07-15","98","7500","Paid to Vinod.","","","","cheque","3168","Vinod");
INSERT INTO expenses VALUES("9485","1","","","2017-07-11","98","3000","Paid to Rehan.","","","","cheque","3160","Rehan");
INSERT INTO expenses VALUES("9486","1","","","2017-10-11","121","10000","Purchase Paint Material.","","","","cheque","3293","Afsar");
INSERT INTO expenses VALUES("9487","1","","","2017-10-07","120","5000","Salary paid to Mahboob for the month of September,","","","","cheque","3273","Mahboob");
INSERT INTO expenses VALUES("9488","1","","","2017-12-11","121","25000","Purchase Paint Material.","","","","cheque","3363","Afsar");
INSERT INTO expenses VALUES("9489","1","","","2017-11-15","119","20000","CASH PAID:Iftequar unnisa.","","","","cheque","3336","IFTEQAR UNNISA	");
INSERT INTO expenses VALUES("9490","1","","","2017-11-15","120","30000","Staff salary paid for the month of October,","","","","cheque","3337","Farzana");
INSERT INTO expenses VALUES("9491","1","","","2017-12-08","124","10000","Loan amount return to Parveen.","","","","cheque","3357","PRAVEEN");
INSERT INTO expenses VALUES("9492","1","","","2017-12-04","119","40000","Cash paid to Sanober.","","","","cheque","3354","Sanober");
INSERT INTO expenses VALUES("9493","1","","","2017-10-31","119","5000","TRFR TO:TELANGANA CHARITABLE TRUST.","","","","cheque","3311","TELANGANA CHARITABLE TRUST.");
INSERT INTO expenses VALUES("9494","1","","","2017-11-08","98","2900","Paid to MOHAMMED MUSAHED.","","","","cheque","3321","MOHAMMED MUSAHED");
INSERT INTO expenses VALUES("9495","1","","","2018-01-18","124","50000","Loan amount return. ","","","","cheque","3396","Basith");
INSERT INTO expenses VALUES("9496","1","","","2018-03-02","110","100000","Rs 50000 cash & Rs 50000 cheque for purchase of lift. ","","","","cheque","3443","Rehan ");
INSERT INTO expenses VALUES("9497","1","","","2018-06-11","120","9500","May Salary paid.","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9498","1","","","2018-08-01","120","28000","Salary paid from January 2018 to August 2018","","","","cash","","Mahoob");
INSERT INTO expenses VALUES("9499","1","","","2018-06-11","125","10000","2 doors and 1 staircase. Total amount is Rs 18000/- ballance is Rs 8000/-.","","","","cash","","Sajid ");
INSERT INTO expenses VALUES("9500","1","","","2018-03-23","110","300000","Paid cash for lift purchase ","","","","cash","","Farooqui");
INSERT INTO expenses VALUES("9501","1","","","2018-06-12","10","20000","Labour payment.","","","","cheque","3623","Trupatty");
INSERT INTO expenses VALUES("9502","1","","","2017-06-28","125","90000","Ballance amount paid.","","","","cash","","Sajid");
INSERT INTO expenses VALUES("9503","1","","","2018-06-02","10","14000","Paid labour payment.","","","","cheque","3626","Tirupathi");
INSERT INTO expenses VALUES("9504","1","","","2018-06-02","101","20000","Paid labour payment.","","","","cheque","3624","Jamal");
INSERT INTO expenses VALUES("9505","1","","","2018-06-19","125","44000","Purchase of 2 new gates.","","","","cheque","3507","Sajid");
INSERT INTO expenses VALUES("9506","1","","","2018-06-19","10","25000","Paid labour payment.","","","","cheque","3508","Tirupathi");
INSERT INTO expenses VALUES("9507","1","","","2018-06-20","18","5000","Paid labour payment for shifting of material.","","","","cheque","3511","Aqtar labour");
INSERT INTO expenses VALUES("9508","1","","","2018-06-20","18","9500","Paid balance amount for digging main line.","","","","cheque","3510","Ravi");
INSERT INTO expenses VALUES("9509","1","","","2018-06-20","14","7000","Purchase of Red Bricks.","","","","cheque","3509","Basith");
INSERT INTO expenses VALUES("9510","1","","","2018-06-22","2","3100","Purchase of cement.","","","","cash","","Aladdin Traders");
INSERT INTO expenses VALUES("9511","1","","","2016-07-15","9","50000","CASH PAID:K SRINIVAS RAO.","","","","cheque","14218","Senu");
INSERT INTO expenses VALUES("9512","1","","","2016-07-16","114","17500","Purchase of Steels.","","","","cheque","14220","H S M STEELS");
INSERT INTO expenses VALUES("9513","1","","","2016-09-20","119","4000","Paid to:  A P LINES BOREWELL AND PUMP.","","","","cheque","3197","Borewell & Pump");
INSERT INTO expenses VALUES("9514","1","","","2016-10-12","115","1411","Land line phone bill paid.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9515","1","","","2016-10-13","115","1157","Paid Land line phone bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9516","1","","","2016-11-29","10","50000","TRFR TO:K THRUPATHI SWAMI.","","","","cheque","3211","Tirupathi");
INSERT INTO expenses VALUES("9517","1","","","2016-05-06","2","6000","Purchase 20 bags @ Rs 300/-","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9518","1","","","2016-05-08","2","3150","Purchase 10 Bags @ Rs 300/- + Transportation.","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9519","1","","","2016-05-09","2","3000","Purchase 10 Bags @ Rs 300/- ","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9520","1","","","2016-05-13","2","155550","Purchase  510  Bags @ Rs 305.","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9521","1","","","2016-05-29","2","55100","Purchase 170 Cements Bags @ Rs 320 + labour.","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9522","1","","","2016-05-29","2","55300","Purchase 170 Cements Bags @ Rs 320 + labour charges.","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9523","1","","","2016-06-17","2","55200","Purchase cement @ Rs 320 + hamali .","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9524","1","","","2016-07-21","2","52650","Purchase 170 bags cement @ Rs 305. + hamali Rs 800. By Cheque  Rs 50000/- by cash Rs 2650/-","","","","cheque","","Junaid");
INSERT INTO expenses VALUES("9525","1","","","2016-08-17","2","30000","Purchase 170 bags @ Rs 285 paid Rs 30000/-   due Rs 18450/-
\n","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9526","1","","","2016-08-26","2","18600","Paid due amount for cement which was purchase on 17 Aug.	
\n","","","","cash","","Ghouse");
INSERT INTO expenses VALUES("9527","1","","","2016-10-08","2","25150","Cement purchase @ 355 X 70 + Hammali.","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9528","1","","","2016-05-13","2","3000","Paid Labour payment for unloading of cement bags.","","","","cash","","Labours");
INSERT INTO expenses VALUES("9529","1","","","2016-10-09","2","28720","Cement purchase @ 355 X 80 + Hammali.","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9530","1","","","2016-10-09","2","3500","Cement purchase on cash (loose) @ Rs 340.
\n","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9531","1","","","2016-11-09","2","120800","Cement(Suvarna) purchase @ Rs 264 / 400 Bags + Hamali.
\n","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9532","1","","","2016-11-01","2","54800","Cement(Survana) purchase @ Rs 270 / 200 Bags + Hamali.
\n","","","","cash","","Junaid");
INSERT INTO expenses VALUES("9533","1","","","2017-02-08","2","750","Cement Hammali @ 5X150.","","","","cash","","Labours");
INSERT INTO expenses VALUES("9534","1","","","2017-02-22","2","1000","Cement hammali @ 5X200.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9535","1","","","2017-03-10","2","1000","Labour payment for cement hammali.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9536","1","","","2016-05-07","1","31000","Purchase 1 Load @ Rs 1050 per tone.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9537","1","","","2016-05-13","1","30000","Purchase 1 load @ Rs 1100 Per Tone.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9538","1","","","2016-05-15","1","26000","Purchase 1 load @ Rs 1100 Per Tone.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9539","1","","","2016-05-28","1","31539","Purchase 1 Lorry Reth @ 1350 per tone.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9540","1","","","2016-05-29","1","31910","Purchase 1 Lorry Reth @ 1350 per tone.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9541","1","","","2016-06-09","1","40000","1 lorry sand purchase. Net weight 30.400 @ Rs 1300.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9542","1","","","2016-06-17","1","14400","Purchase sand.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9543","1","","","2016-06-18","1","33500","Purchase Sand.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9544","1","","","2016-07-21","1","41000","Purchase one lorry Rethi (1 floor column raise).
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9545","1","","","2016-08-27","1","42000","Paid for rethi which was purchase on 17 Aug 16.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9546","1","","","2016-08-27","1","85500","Sand purchase and old due clear.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9547","1","","","2016-11-04","1","50000","Sand purchase on 27-10-16 @2500 per tone. Total 71500.Paid Rs 50000,  Balance Rs 21500
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9548","1","","","2016-12-21","1","100000","Paid Rethi purchase due for 3 lorryies and old due Rs 21500.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9549","1","","","2017-01-19","1","34000","Sand purchase.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9550","1","","","2017-02-22","1","50000","Sand old due paid Rs 50000 & balance Rs 16000/-
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9551","1","","","2017-02-22","1","35000","Sand purchase.
\n","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9552","1","","","2017-02-22","1","25000","Sand purchase.","","","","cash","","VENKATESH");
INSERT INTO expenses VALUES("9553","1","","","2016-05-09","114","1650","Purchase 25 Kg binding wire @ 65 per Kg.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9554","1","","","2016-05-10","114","1250","Purchase 25 Kg binding wire.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9555","1","","","2016-05-24","114","167640","Purchase steel.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9556","1","","","2016-06-02","114","42181","Purchase steel.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9557","1","","","2016-06-06","114","22172","Purchase steel.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9558","1","","","2016-06-16","114","40000","Purchase steel paid Rs 40000 &  balance Rs 8073.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9559","1","","","2016-07-06","114","14973","Purchase binding wire and covering boxes & paid old balance Amt. Rs 8073. (Payment by cheque HSM Ste","","","","cheque","","Iqbal");
INSERT INTO expenses VALUES("9560","1","","","2016-07-06","114","341000","Steel purchase and amount transfer to america.","","","","bank transfer","","America");
INSERT INTO expenses VALUES("9561","1","","","2016-07-13","114","2700","Purchase binding wire.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9563","1","","","2016-07-18","114","5500","Purchase binding wire 4 bundle.","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9564","1","","","2016-08-05","114","200000","Steel purchase.","","","","cheque","","Afaq");
INSERT INTO expenses VALUES("9565","1","","","2016-08-17","114","800","Paid Labour payment for steel unload.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9566","1","","","2015-08-25","114","150000","Paid to Afaq for steel.","","","","cheque","","Afaq");
INSERT INTO expenses VALUES("9567","1","","","2016-08-25","114","43000","Steel old due clear (iqbal steel).","","","","cash","","Iqbal");
INSERT INTO expenses VALUES("9568","1","","","2016-08-18","114","200000","steel amount paid.
\n","","","","cheque","","Iqbal");
INSERT INTO expenses VALUES("9569","1","","","2016-04-21","77","15500","Cash paid for new electricity meter.
\n","","","","cash","","TSSPDCL");
INSERT INTO expenses VALUES("9570","1","","","2016-05-24","77","810","Purchase electrical material for small pump.","","","","cash","","DEVA");
INSERT INTO expenses VALUES("9571","1","","","2016-07-15","77","9400","Purchase electrical Pipe for Ground Floor Slab (payment by cheque sawanth)
\n","","","","cheque","","Sawanth");
INSERT INTO expenses VALUES("9572","1","","","2016-07-19","77","15000","Paid for shifting of pole advance balance is Rs 15000.
\n","","","","cash","","Aleem");
INSERT INTO expenses VALUES("9573","1","","","2016-08-02","77","2800","Part electrical purchase for 1st floor slab, issue cheque.
\n","","","","cheque","","DEVA");
INSERT INTO expenses VALUES("9574","1","","","2016-10-09","77","9000","Mukesh electrical bill cleared for 4 slab piping.
\n","","","","cash","","DEVA");
INSERT INTO expenses VALUES("9575","1","","","2017-01-23","77","22000","Electrical purchase for pipping the flats (10).","","","","cash","","DEVA");
INSERT INTO expenses VALUES("9576","1","","","2017-01-23","77","20000","Electrical purchase for 6 slab pipping which was due.
\n","","","","cash","","DEVA");
INSERT INTO expenses VALUES("9577","1","","","2016-05-20","5","12484","Purchase hardware Sanitary material .
\n","","","","cash","","SANITARY & ELECTRICAL");
INSERT INTO expenses VALUES("9578","1","","","2016-05-24","101","2700","Paid labour charges for fitting of tanks and pump.
\n","","","","cash","","Jamal");
INSERT INTO expenses VALUES("9579","1","","","2016-05-24","5","800","Purchase sanatary for small pump.
\n","","","","cash","","SANITARY & ELECTRICAL");
INSERT INTO expenses VALUES("9580","1","","","2016-06-16","5","3000","Purchase pipe for school dranige line + Transportation.
\n","","","","cash","","SANITARY");
INSERT INTO expenses VALUES("9581","1","","","2016-06-16","101","6000","Paid plumber charges to start dranige line.","","","","cash","","Jamal");
INSERT INTO expenses VALUES("9582","1","","","2016-08-18","5","2226","Purchase sanitary material for sump.","","","","cash","","SANITARY");
INSERT INTO expenses VALUES("9583","1","","","2016-10-31","101","10000","Plumbing work for water supply for all floor + labour payment with material bill.","","","","cash","","Jamal");
INSERT INTO expenses VALUES("9584","1","","","2016-05-06","126","4800","Purchase Mota Kankar 3 Lorry @ Rs 1600/-
\n","","","","cash","","Mota kankar");
INSERT INTO expenses VALUES("9585","1","","","2016-05-07","126","6400","Purchase Mota Kankar  4 Lorry @ Rs 1600/-","","","","cash","","Mota kankar");
INSERT INTO expenses VALUES("9586","1","","","2016-05-16","126","5900","Purchase 300 Sq.Ft. 20 MM.
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9587","1","","","2016-05-14","126","5900"," Purchase Kankar 20 MM 300 Sq Feet.
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9588","1","","","2016-05-14","126","4300"," Purchase Kankar 20 MM 200 Sq Feet.
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9589","1","","","2016-05-14","126","6000","Purchase Kankar 20 MM 300 Sq Feet .
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9590","1","","","2016-05-15","126","6000"," Purchase Kankar 20 MM 300 Sq Feet.
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9591","1","","","2016-05-21","126","5400","Purchase 3 Lorry Mota Kankar @ Rs 1800/-","","","","cash","","Mota kankar");
INSERT INTO expenses VALUES("9592","1","","","2016-05-28","126","18000","Purchase 3 Lorry 22MM Kankar @ Rs /-  6000.","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9593","1","","","2016-06-09","126","12000"," purchas 2 lorry 20 MM @ Rs 6000.","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9594","1","","","2016-06-09","126","7000","Powder purchase.","","","","cash","","Powder");
INSERT INTO expenses VALUES("9595","1","","","2016-06-15","126","36000","Purchase 16 lorry mota kankar and 4 lorry ganate.
\n","","","","cash","","Mota kankar");
INSERT INTO expenses VALUES("9596","1","","","2016-06-16","126","6000","Two lorry ganate purchase Rs 3000 each.
\n","","","","cash","","Ganate");
INSERT INTO expenses VALUES("9597","1","","","2016-06-16","126","19000","Purchase 60MM mota kankar and ganat ( paid anand vocher sign for 3 bills).","","","","cash","","Mota kankar");
INSERT INTO expenses VALUES("9598","1","","","2016-06-17","126","6000","Purchase 20MM Kankar.","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9599","1","","","2016-06-18","126","7000","1 lorry powder purchase.","","","","cash","","Powder");
INSERT INTO expenses VALUES("9600","1","","","2016-06-17","126","14000","2 Lorry powder purchase.","","","","cash","","Powder");
INSERT INTO expenses VALUES("9601","1","","","2016-06-17","126","6000","1 lorry kankar 20 mm purchase.
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9602","1","","","2016-07-21","126","6000","Purchase one lorry 20 MM (1 floor column raise).","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9603","1","","","2016-08-27","126","12400","2 lorry 20 MM purchase @ Rs 6200 which was purchase on 17 Aug.	
\n","","","","cash","","20MM Kankar");
INSERT INTO expenses VALUES("9604","1","","","2016-12-27","8","90250","Door frames purchase 36 bill attached + Transportation.
\n","","","","cash","","Shabbir");
INSERT INTO expenses VALUES("9605","1","","","2016-12-27","8","105000","Door frames purchase 42 bill attached + Transportation.
\n","","","","cash","","Shabbir");
INSERT INTO expenses VALUES("9610","1","","","2016-06-20","14","5000","Purchase Red Bricks for staircase marking.","","","","cash","","Babu");
INSERT INTO expenses VALUES("9611","1","","","2016-12-21","14","29000","Purchase 1 lorry red bricks @5.10X5700 (local)","","","","cash","","Babu");
INSERT INTO expenses VALUES("9612","1","","","2017-01-08","14","30600","Purchase 1 lorry red bricks @5.10X6000","","","","cash","","Babu");
INSERT INTO expenses VALUES("9613","1","","","2016-07-08","14","75500","Purchase Bricks MMS balance paid on 29oct 25500.
\n","","","","cash","","Babu");
INSERT INTO expenses VALUES("9614","1","","","2016-08-14","14","95000","Purchase Bricks ABI.
\n","","","","cash","","Babu");
INSERT INTO expenses VALUES("9615","1","","","2016-09-19","14","96000","Purchase Bricks ABC Rs 6.40X15000.
\n","","","","cash","","Babu");
INSERT INTO expenses VALUES("9616","1","","","2016-10-28","14","96000","Purchase Bricks ABC Rs 6.40X15000.","","","","cash","","Babu");
INSERT INTO expenses VALUES("9617","1","","","2016-11-04","14","79200","Purchase Bricks ABC Rs 6.60X12000.
\n","","","","cash","","Babu");
INSERT INTO expenses VALUES("9618","1","","","2017-01-19","14","64000","Bricks purchase @ 6.60 PVC.","","","","cash","","Babu");
INSERT INTO expenses VALUES("9619","1","","","2016-05-05","98","3000","Purchase water pipe ( 4 bundle + joints).","","","","cash","","Water Pipe");
INSERT INTO expenses VALUES("9620","1","","","2016-07-18","12","6000","Paid for Pin and vibrator.
\n","","","","cash","","Pin and vibrator");
INSERT INTO expenses VALUES("9621","1","","","2016-08-15","12","4000","Pin and vibrator for first floor slab.","","","","cash","","Pin and vibrator");
INSERT INTO expenses VALUES("9622","1","","","2016-08-27","12","6000","Paid for Miller, lift, pin vibrator.
\n","","","","cash","","Senu");
INSERT INTO expenses VALUES("9623","1","","","2016-07-26","12","7000","Paid to Miller, lift and pin for two days (1 floor column raise)","","","","cash","","Pin and vibrator");
INSERT INTO expenses VALUES("9624","1","","","2016-06-17","12","4000","Miller at time of columns 2 days .
\n","","","","cash","","Miller");
INSERT INTO expenses VALUES("9625","1","","","2016-05-06","98","3500","Purchase barell for water + transportation.","","","","cash","","Barel");
INSERT INTO expenses VALUES("9626","1","","","2016-05-07","98","1000","Purchase line dori and other material for marking.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9627","1","","","2016-05-14","98","500","Buckets purchase.","","","","cash","","Bucket");
INSERT INTO expenses VALUES("9628","1","","","2016-05-18","98","300","Purchase blue cover for protection of wall. (small)
\n","","","","cash","","Blue cover");
INSERT INTO expenses VALUES("9629","1","","","2016-05-19","98","700000","Purchase blue cover for protection of wall. (big)
\n","","","","cash","","Blue cover");
INSERT INTO expenses VALUES("9630","1","","","2016-05-31","98","1400","Purchase Gampa and phoda.
\n","","","","cash","","Ganpa & Phaoda");
INSERT INTO expenses VALUES("9631","1","","","2016-06-16","98","250","Oil purchase.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9632","1","","","2016-06-20","98","100","Purchase Nail.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9633","1","","","2016-02-07","98","1700","Purchase Tabs for washroom and labour charges.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9634","1","","","2016-10-13","98","180","Dambar purchase for door frames.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9635","1","","","2016-08-03","98","650","Purchase blue cover.","","","","cash","","Blue cover");
INSERT INTO expenses VALUES("9636","1","","","2016-11-09","98","1300","Exost Fan Blocks purchase @ Rs 50 / 23 Blocks + Auto 150.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9637","1","","","2016-08-17","98","4000","3 Stulls purchase @ Rs 1300 each + transportation Rs 300.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9638","1","","","2016-08-18","98","2050","Cement hammali, petrol, rassi, Labour tip, petrol, acid and phinil.	","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9639","1","","","2016-10-29","98","1100","Purchase 2 Blue Sheet.","","","","cash","","Blue cover");
INSERT INTO expenses VALUES("9640","1","","","2016-10-29","98","2570","Oil purchase,
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9641","1","","","2016-10-29","98","400","Petrol.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9642","1","","","2016-08-29","98","50000","Paid to Senu for  other purchase.","","","","cash","","Senu");
INSERT INTO expenses VALUES("9643","1","","","2016-08-15","98","4300","Hardware purchase + others.
\n","","","","cash","","SANITARY");
INSERT INTO expenses VALUES("9644","1","","","2016-10-15","98","600","Gampa purchase.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9645","1","","","2016-10-15","98","4412","Wholepass and other purchase.","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9646","1","","","2016-10-15","98","500","Transportation.
\n","","","","cash","","Transport");
INSERT INTO expenses VALUES("9647","1","","","2016-11-09","98","1650","Blue sheet purchase (3) Rs 550 each.","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9648","1","","","2017-01-03","98","750","	Kabutar jali purchase (3 bundle @ Rs 260 each)","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9649","1","","","2017-01-03","98","70","Sisour purchase to cut jali .","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9650","1","","","2016-04-24","98","10000","2 Goats slature.","","","","cash","","Goats");
INSERT INTO expenses VALUES("9651","1","","","2016-05-06","98","5000","1 Goat slature","","","","cash","","Goats");
INSERT INTO expenses VALUES("9652","1","","","2016-05-13","98","600","Purchase Tourch for watchman.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9653","1","","","2016-05-14","12","4000","Miller Rent at the time of footing.","","","","cash","","Miller");
INSERT INTO expenses VALUES("9654","1","","","2016-05-15","98","5000","1 Goat slature.
\n","","","","cash","","Goats");
INSERT INTO expenses VALUES("9655","1","","","2016-05-16","12","45000","JCB for cleaning of plot and lifting of mud.","","","","cash","","JCB");
INSERT INTO expenses VALUES("9656","1","","","2016-05-16","98","11000","11 Lorrys on rent for shifting of mud @ Rs 1000 per lorry.
\n","","","","cash","","Lorry Rent");
INSERT INTO expenses VALUES("9657","1","","","2016-05-28","98","1800","28-May-16	3 Lorry dismelting thrown @ Rs 600 each.
\n","","","","cash","","Dismelting");
INSERT INTO expenses VALUES("9658","1","","","2016-05-28","12","2000","JCB for cleaning of plot and lifting of mud (3 Hours)
\n","","","","cash","","JCB");
INSERT INTO expenses VALUES("9659","1","","","2016-06-04","12","5625","JCB for cleaning of plot and closing columns pits.
\n","","","","cash","","JCB");
INSERT INTO expenses VALUES("9660","1","","","2016-06-11","12","4800","Paid to JCB for digging of sump and cleaning of plot.","","","","cash","","JCB");
INSERT INTO expenses VALUES("9661","1","","","2016-09-10","12","6000","Paid total miller charges.
\n","","","","cash","","Miller");
INSERT INTO expenses VALUES("9662","1","","","2016-11-26","98","5000","Paid tips for slab of 5 floor.","","","","cash","","Tips");
INSERT INTO expenses VALUES("9663","1","","","2016-06-23","98","250","Xerox and lamination.
\n","","","","cash","","SELF");
INSERT INTO expenses VALUES("9664","1","","","2016-06-27","98","200","Paid for tea to steel driver.
\n","","","","cash","","Tips");
INSERT INTO expenses VALUES("9665","1","","","2016-07-05","98","300","Paid for tea to steel driver.","","","","cash","","Tips");
INSERT INTO expenses VALUES("9666","1","","","2016-12-22","98","6000","Bakra salutar.
\n","","","","cash","","Goat");
INSERT INTO expenses VALUES("9667","1","","","2016-12-22","98","2570","Oil purchase blue cover and rassi.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9668","1","","","2016-07-17","98","400","Petrol purchase.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9669","1","","","2016-09-17","98","5000","Paid Tips at the time of slab.
\n","","","","cash","","Tips");
INSERT INTO expenses VALUES("9670","1","","","2016-12-22","98","4775","Paid to Mahoob saab (Old Miscellaneous)","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9671","1","","","2016-12-25","13","5000","Paid to labour for cleaning all floor slabs.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9672","1","","","2017-01-26","98","280","Hole pass purchase.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9673","1","","","2017-01-26","98","200","Nails purchase.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9674","1","","","2016-07-26","98","1000","Anil, Petrol, oil, water.
\n","","","","cash","","Anil & Others");
INSERT INTO expenses VALUES("9675","1","","","2016-07-26","98","20000","First floor slab miscellenous amount taken from school.","","","","cash","","SELF");
INSERT INTO expenses VALUES("9676","1","","","2016-04-20","119","1000","Paid for checking of  bore well point.
\n","","","","cash","","Aziz Khan");
INSERT INTO expenses VALUES("9677","1","","","2016-04-22","119","100000","Cheque issue for drilling of borewell.","","","","cheque","","Borewell & Pump");
INSERT INTO expenses VALUES("9678","1","","","2016-04-24","119","104000","Cash paid for dirilling of borewell.","","","","cash","","Borewell & Pump");
INSERT INTO expenses VALUES("9679","1","","","2016-05-03","119","186500","Paid to  borewell for 2 Pump (a. 950 Sq feet & b. 850 Sq Feet deep) ","","","","cash","","Borewell & Pump");
INSERT INTO expenses VALUES("9680","1","","","2016-05-20","119","5700","Purchase 1 HP Pump.
\n","","","","cash","","Borewell & Pump");
INSERT INTO expenses VALUES("9681","1","","","2016-05-04","13","10000","Paid advance for digging of pits (part payment)","","","","cash","","Labours");
INSERT INTO expenses VALUES("9682","1","","","2016-05-07","13","10000","Paid for digging of pits (2nd part payment)
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9683","1","","","2016-05-08","13","12000","Paid Final payment for digging in 16 pits @ Rs 2000 per pit.","","","","cash","","Labours");
INSERT INTO expenses VALUES("9684","1","","","2016-05-01","13","4000","Paid to Labour for breaking old house (JCB)","","","","cash","","JCB");
INSERT INTO expenses VALUES("9685","1","","","2015-05-19","13","15000","Paid Advance Labour charges for digging of Pits for Column.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9686","1","","","2016-05-24","13","9000","Paid labour charges for digging of pits (full payment)
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9687","1","","","2016-05-27","13","8000","Labour charges for plinth beam cleaning 8 pairs @ Rs 1000.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9688","1","","","2016-06-02","13","13625","Paid to pashu ram labour payment + JCB.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9689","1","","","2016-06-16","13","10000","Paid labour charges to pashu ram for cleaning of area splitting mota kankar.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9690","1","","","2016-06-23","89","10000","Paid labour charges.","","","","cheque","","Ibrahim");
INSERT INTO expenses VALUES("9691","1","","","2016-06-27","13","3000","Paid to Pashuram  labour payment.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9692","1","","","2016-06-27","13","700","Paid to labour for shifting of dust inside.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9693","1","","","2016-08-15","13","4000","Paid to Pashuram labour payment.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9694","1","","","2016-08-27","13","900","Paid 2 labour charges for shifting cement bags inside thru senu.","","","","cash","","Labours");
INSERT INTO expenses VALUES("9695","1","","","2016-09-15","13","1300","Paid labour charges for cleaning of slab.","","","","cash","","Labours");
INSERT INTO expenses VALUES("9696","1","","","2016-09-28","13","2000","Paid to Labour for oil.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9697","1","","","2016-10-20","13","1200","Paid Labour charges for cleaning of road and bringing steel inside our boundry.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9698","1","","","2016-11-06","13","2000","Paid Labour charges for oil and blue cover.","","","","cash","","Labour");
INSERT INTO expenses VALUES("9699","1","","","2016-11-22","13","800","Paid Labour payment for colouring door frames.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9700","1","","","2016-12-19","13","400","Paid Labour payment for cleaning ground floor slab.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9701","1","","","2017-01-05","13","4000","Paid labour charges for cleaning school back plot.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9702","1","","","2017-01-05","13","200","labour for curing (watchman replacement)
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9703","1","","","2017-01-18","13","5000","Paid labour payment of goya tying.","","","","cash","","Senu");
INSERT INTO expenses VALUES("9704","1","","","2017-01-20","13","6300","Paid to labour for chipping slab for elevation.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9705","1","","","2017-02-08","13","1500","Paid to department labour for cleaning.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9706","1","","","2017-02-18","13","1300","Paid to labour on contract for breaking kitchen wall.","","","","cash","","Labour");
INSERT INTO expenses VALUES("9707","1","","","2017-03-04","13","1800","Paid department labour payment.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9708","1","","","2016-05-11","127","10000","Given money to Corporator.","","","","cash","","Corporator");
INSERT INTO expenses VALUES("9709","1","","","2016-06-27","127","1500","Paid to MCH.
\n","","","","cash","","MCH");
INSERT INTO expenses VALUES("9710","1","","","2016-07-17","127","10000","Paid bribe to corporator.","","","","cash","","Corporator");
INSERT INTO expenses VALUES("9711","1","","","2016-08-17","127","10000","Paid bribe to corporator.
\n","","","","cash","","Corporator");
INSERT INTO expenses VALUES("9712","1","","","2016-09-20","127","200000","Given bribe to MLA.","","","","cash","","MLA");
INSERT INTO expenses VALUES("9713","1","","","2016-10-16","127","50000","Given Bribe to Corporator ( Jaweed )
\n","","","","cash","","Corporator");
INSERT INTO expenses VALUES("9714","1","","","2016-11-20","127","100000","Given money to Munavar for stay order.
\n","","","","cash","","Munavar");
INSERT INTO expenses VALUES("9715","1","","","2016-12-29","127","200000","Cash paid to Munavar for stay order.
\n","","","","cash","","Munavar");
INSERT INTO expenses VALUES("9716","1","","","2017-03-04","127","20000","Paid to Aleem for pole shifting work (WITHDRAW 45K)
\n","","","","cash","","Aleem");
INSERT INTO expenses VALUES("9717","1","","","2016-05-09","18","9850","Purchase Gova Lakdi and Tadka + Transportation.
\n","","","","cash","","Gova lakdi");
INSERT INTO expenses VALUES("9718","1","","","2016-06-20","18","6700","Purchase balli (gova Lakdi) 
\n","","","","cash","","Gova lakdi");
INSERT INTO expenses VALUES("9719","1","","","2016-07-26","18","1400","5 Tadka purchase @ Rs 250 each + transportation.
\n","","","","cash","","Tadka");
INSERT INTO expenses VALUES("9720","1","","","2017-01-04","18","16600","Purchase Lakdi for goa + transportation + hammali.
\n","","","","cash","","Gova lakdi");
INSERT INTO expenses VALUES("9721","1","","","2017-01-06","18","15500","Purchase Lakdi for goa + transportation + hammali.","","","","cash","","Gova lakdi");
INSERT INTO expenses VALUES("9722","1","","","2016-10-16","98","500","Paid for misclenous.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9723","1","","","2016-11-13","98","2000","Paid for misclenous.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9724","1","","","2016-11-27","123","15000","Designing amount paid for broucher.
\n","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("9725","1","","","2016-12-09","98","5000","Paid for misclenous.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9726","1","","","2016-12-14","111","650","Internet bill paid.
\n","","","","cash","","Internet bill ");
INSERT INTO expenses VALUES("9727","1","","","2017-01-25","98","1200","Paid for dismilting 2 lorry.","","","","cash","","Dismelting");
INSERT INTO expenses VALUES("9728","1","","","2017-01-29","98","1200","Buckets purchase.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9729","1","","","2017-02-18","98","700","Miscellenous paid.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9730","1","","","2017-02-18","18","6000","Tadka purchase advance paid. Balance 10000.","","","","cash","","Tadka");
INSERT INTO expenses VALUES("9731","1","","","2017-02-22","18","10000","Tadka balance amount paid .","","","","cash","","Tadka");
INSERT INTO expenses VALUES("9732","1","","","2017-02-22","98","270","kabutar jali purchase (1 bundle @ Rs 270) 
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9733","1","","","2017-02-22","98","1000","Blade purchase.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9734","1","","","2017-02-25","98","2500","Miscellenous paid.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9735","1","","","2017-02-25","98","540","Kabutur jali.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9736","1","","","2017-02-25","98","4000","Hole pass purchase + auto fare+ nails+screw.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9737","1","","","2017-02-25","98","1000","Gampa purchase + auto fare.
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9738","1","","","2017-02-25","98","2500","2 Stool purchase .
\n","","","","cash","","Hardware shop");
INSERT INTO expenses VALUES("9739","1","","","2017-03-04","98","2000","Rethi supply brokerage charges.
\n","","","","cash","","Rethi brokerage");
INSERT INTO expenses VALUES("9740","1","","","2017-03-04","13","4700","Paid Labour charges for rethi shifting.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("9741","1","","","2017-03-04","120","5000","Paid  half salary to Kishore.
\n","","","","cash","","Kishore");
INSERT INTO expenses VALUES("9742","1","","","2016-05-06","120","5000","Salary paid to watchman.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9743","1","","","2016-06-06","120","5000","Salary paid to watchman.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9744","1","","","2016-06-15","120","10000","Watchman salary paid.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9745","1","","","2016-07-06","120","5000","Salary paid to watchman.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9746","1","","","2016-08-03","120","1000","Advance paid to new watchman (for shifting)
\n","","","","cash","","New Watchman");
INSERT INTO expenses VALUES("9747","1","","","2016-08-03","120","1000","Salary paid toilet cleaner.","","","","cash","","Anil");
INSERT INTO expenses VALUES("9748","1","","","2016-08-03","98","1000","Paid to Neighbour  shakeel.","","","","cash","","Shakeel");
INSERT INTO expenses VALUES("9749","1","","","2016-08-15","120","4000","Paid to Temporary Watchman Salary.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9750","1","","","2016-08-15","120","3000","Paid  Salary to Temporary Watchman.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9751","1","","","2016-08-27","120","1500","Paid advance to watchman (joining date is 21 aug)","","","","cash","","New Watchman");
INSERT INTO expenses VALUES("9752","1","","","2016-08-27","120","4000","Paid to Mahoob saab for (watchman salary,borewell repair, others)	
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9753","1","","","2016-08-27","120","1000","Paid  advance salary to Pasha watchman.","","","","cash","","Pasha");
INSERT INTO expenses VALUES("9754","1","","","2016-09-05","120","7000","Paid Watchman salary.","","","","cash","","Watchman");
INSERT INTO expenses VALUES("9755","1","","","2016-09-21","120","8000","Paid watchman salary.
\n","","","","cash","","Pasha");
INSERT INTO expenses VALUES("9756","1","","","2016-10-21","120","8000","Paid watchman salary	.","","","","cash","","Pasha");
INSERT INTO expenses VALUES("9757","1","","","2016-11-21","120","8000","Paid watchman salary.
\n","","","","cash","","Pasha");
INSERT INTO expenses VALUES("9758","1","","","2016-09-21","120","4000","Paid Mahoob saab salary.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9759","1","","","2016-10-21","120","4000","Paid Mahoob saab salary.
\n","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9760","1","","","2016-11-21","120","4000","Paid Mahoob saab salary.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9761","1","","","2016-12-01","120","4000","Paid Mahoob saab salary.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9762","1","","","2016-12-21","120","8000","Watchman  (half)  salary paid.","","","","cash","","Pasha");
INSERT INTO expenses VALUES("9763","1","","","2017-01-04","120","1200","Paid salary to toilet cleaner.","","","","cash","","Anil");
INSERT INTO expenses VALUES("9764","1","","","2017-01-04","120","1000","Paid advance salary to Kishore.","","","","cash","","Kishore");
INSERT INTO expenses VALUES("9765","1","","","2017-01-31","120","4000","Paid Mahoob saab salary.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9766","1","","","2017-02-08","120","1500","Paid salary to toilet cleaner.
\n","","","","cash","","Anil");
INSERT INTO expenses VALUES("9767","1","","","2017-02-10","120","10000","Paid watchman salary.","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9768","1","","","2018-06-25","101","15000","Paid labour payment.","","","","cheque","3513","Jamal");
INSERT INTO expenses VALUES("9769","1","","","2018-06-01","5","31000","Purchase sanitary material J K SANITARY & ELECTRICAL.
\n","","","","cheque","3632","J K SANITARY");
INSERT INTO expenses VALUES("9770","1","","","2018-06-29","5","50000","Purchase sanitary material from SRI LAXMI SALES CORPORATION.
\n","","","","cheque","3590","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9771","1","","","2018-06-01","122","23400","Purchase Robo Sand","","","","cheque","3625","Ravi");
INSERT INTO expenses VALUES("9772","1","","","2018-06-20","122","9500","Purchase Robo Sand
\n","","","","cheque","3510","Ravi");
INSERT INTO expenses VALUES("9773","1","","","2018-06-02","119","20000","TRFR TO: HAPPY SCHOLAR.	
\n","","","","cheque","3622","HAPPY SCHOLAR");
INSERT INTO expenses VALUES("9775","1","","","2018-06-20","14","7000","Purchase Red bricks.","","","","cheque","3509","Basith");
INSERT INTO expenses VALUES("9776","1","","","2018-06-20","13","5000","Paid labour payment.","","","","cheque","3511","Aqtar labour");
INSERT INTO expenses VALUES("9777","1","","","2018-06-25","13","9000","Paid labour payment","","","","cheque","3512","Aqtar labour");
INSERT INTO expenses VALUES("9778","1","","","2018-06-29","89","15000","Pai labour payment.","","","","cheque","3516","Ibrahim");
INSERT INTO expenses VALUES("9779","1","","","2018-06-01","103","40000","Purchase Tiles.","","","","cheque","3627","Adil");
INSERT INTO expenses VALUES("9780","1","","","2018-06-26","119","12000","Labour payment for digging of main line.","","","","cheque","3514","Shareef");
INSERT INTO expenses VALUES("9781","1","","","2018-06-27","119","7100","Paid labour payment for digging of main line.","","","","cheque","3515","Shareef");
INSERT INTO expenses VALUES("9782","1","","","2018-04-07","124","90000","TRFR TO: YASMEEN AFROZE	
\n","","","","cheque","3603","YASMEEN AFROZE");
INSERT INTO expenses VALUES("9783","1","","","2018-04-07","124","200000","TRFR TO: HAPPY SCHOLAR	
\n","","","","cheque","3602","Happy Scholar");
INSERT INTO expenses VALUES("9784","1","","","2018-04-09","129","100000","To Afaq thru MOHIUDDIN MOHD ABDULJABBA	
\n","","","","cheque","3448","Afaq");
INSERT INTO expenses VALUES("9785","1","","","2018-04-09","97","9500","CASH PAID:Mazher (dont remember)
\n","","","","cheque","3606","Mazher");
INSERT INTO expenses VALUES("9786","1","","","2018-04-13","102","10500","CASH PAID:ANWAR as salary on behalf of fzami.
\n","","","","cheque","3610","Anwar");
INSERT INTO expenses VALUES("9787","1","","","2016-05-16","123","120000","Paid from Fzami account. Full and Final payment Paid to Waffi for designing
\n","","","","cheque","","Waffi");
INSERT INTO expenses VALUES("9788","1","","","2016-05-03","123","40000","Ballance payment paid Total amount Rs 120000","","","","cash","","Waffi");
INSERT INTO expenses VALUES("9789","1","","","2016-05-05","114","600000","Cheque withdrawn & purchase steel.
\n","","","","cheque","","Afaq");
INSERT INTO expenses VALUES("9790","1","","","2016-08-18","114","84000","cheque return to iqbal steel amount paid
\n","","","","cheque","","Iqbal");
INSERT INTO expenses VALUES("9791","1","","","2018-12-31","114","200000","Old due to Steel paid.
\n","","","","cash","","Afaq");
INSERT INTO expenses VALUES("9792","1","","","2016-05-10","95","18000","Electricity bill paid for 2 month.","","","","cash","","TSSPDCL");
INSERT INTO expenses VALUES("9793","1","","","2016-10-31","95","5825","Electricity bill paid.
\n","","","","cash","","TSSPDCL");
INSERT INTO expenses VALUES("9794","1","","","2017-03-18","5","12942","Sanitary material  purchase.","","","","cash","","SANITARY");
INSERT INTO expenses VALUES("9795","1","","","2018-02-26","13","6500","CASH PAID TO : Aqtar.","","","","cheque","6500","Aqtar labour");
INSERT INTO expenses VALUES("9796","1","","","2017-09-27","117","25000","CASH PAID TO : WASEEM.","","","","cheque","3239","Waseem Bhai");
INSERT INTO expenses VALUES("9797","1","","","2017-09-25","119","27000","Purchase computers.","","","","cheque","3240","Ali");
INSERT INTO expenses VALUES("9798","1","","","2018-01-18","124","50000","Loan amount return.","","","","cheque","3394","Jawaad");
INSERT INTO expenses VALUES("9799","1","","","2018-01-18","124","50000","Loan amount return.","","","","cheque","3397","Adil");
INSERT INTO expenses VALUES("9800","1","","","2018-01-18","124","50000","Loan amount return.","","","","cheque","3395","Afaq");
INSERT INTO expenses VALUES("9801","1","","","2018-02-16","114","50000","Purchase Steels.","","","","cheque","3432","Iqbal");
INSERT INTO expenses VALUES("9802","1","","","2018-02-17","114","30000","Purchase Steels.","","","","cheque","3434","Iqbal");
INSERT INTO expenses VALUES("9803","1","","","2018-02-02","103","21000","Purchase Tiles from Patel.","","","","cheque","3483","Suraj");
INSERT INTO expenses VALUES("9804","1","","","2018-02-27","114","50000","Puuchase Steels.","","","","cheque","3461","Iqbal");
INSERT INTO expenses VALUES("9805","1","","","2018-02-28","129","50000","Loan amount return to Afaq Hyder.","","","","cheque","3455","Afaq Hyder");
INSERT INTO expenses VALUES("9806","1","","","2018-02-28","129","50000","Loan amount return to Jawad.","","","","cheque","3454","Jawaad");
INSERT INTO expenses VALUES("9807","1","","","2018-02-28","129","50000","Loan amount return to MUSTAQ  HYDER.","","","","cheque","3457","MUSTAQ  HYDER");
INSERT INTO expenses VALUES("9808","1","","","2018-02-28","129","50000","Loan amount return to ALI  HYDER.","","","","cheque","3456","ALI  HYDER");
INSERT INTO expenses VALUES("9809","1","","","2018-02-28","13","8000","Paid labour payment for digging work.","","","","cheque","3452","Pashu Ram ");
INSERT INTO expenses VALUES("9810","1","","","2017-06-14","124","50000","Loan amount return.","","","","cheque","3198","SHAIK KASHIF");
INSERT INTO expenses VALUES("9811","1","","","2017-06-22","124","60000","Loan amount return taken from Afaq.","","","","cheque","3200","SRINATH RAO");
INSERT INTO expenses VALUES("9812","1","","","2018-03-02","129","56500","Loan amount return which was taken from Afaq.","","","","cheque","3451","Imran Khan");
INSERT INTO expenses VALUES("9813","1","","","2018-03-02","124","10000","Loan amount return which was taken from Afaq.","","","","cheque","3446","Afzal");
INSERT INTO expenses VALUES("9814","1","","","2018-03-02","124","50000","Loan amount return which was taken from Afaq.","","","","cheque","3444","Farooq");
INSERT INTO expenses VALUES("9815","1","","","2018-03-03","13","6500","Paid labour payment.","","","","cheque","3473","Aqtar labour");
INSERT INTO expenses VALUES("9816","1","","","2018-03-03","129","50000","Loan amount return which was taken from Afaq.","","","","cheque","3440","MUSTAQ  HYDER");
INSERT INTO expenses VALUES("9817","1","","","2018-03-03","129","50000","Loam amount return which was taken from Afaq.","","","","cheque","3439","ALI  HYDER");
INSERT INTO expenses VALUES("9818","1","","","2018-03-03","129","50000","Loan amount return to Afaq Hyder.","","","","cheque","3437","Afaq Hyder");
INSERT INTO expenses VALUES("9819","1","","","2018-03-03","129","50000","Loan amount return which was taken from Afaq.","","","","cheque","3438","Jawad");
INSERT INTO expenses VALUES("9820","1","","","2018-03-07","124","50000","Loan amount return to Afaq Hyder.","","","","cheque","3596","Afaq Hyder");
INSERT INTO expenses VALUES("9821","1","","","2018-03-07","124","33000","Loan amount return which was taken from Afaq.","","","","cheque","3597","Ali Hyder");
INSERT INTO expenses VALUES("9822","1","","","2018-03-07","124","50000","Loan amount return which was taken from Afaq.","","","","cheque","3595","Jawad");
INSERT INTO expenses VALUES("9823","1","","","2018-02-27","124","34000","Loan amount return which was taken from Afaq.","","","","cheque","3472","Mohd Basha Ahmed");
INSERT INTO expenses VALUES("9824","1","","","2017-10-06","124","50000","Loan amount return which was taken from Afaq.","","","","cheque","3269","Jawad");
INSERT INTO expenses VALUES("9825","1","","","2018-03-06","124","50000","Loan amount return which was taken from Afaq.","","","","cheque","3592","Taher");
INSERT INTO expenses VALUES("9826","1","","","2017-12-08","124","50000","Loan amount return which was taken from Afaq.","","","","cheque","3358","Taher");
INSERT INTO expenses VALUES("9827","1","","","2017-12-14","124","50000","Loan amount return which was taken from Afaq.","","","","cheque","3364","Mohd Basha Ahmed");
INSERT INTO expenses VALUES("9828","1","","","2017-07-05","119","12000","Paid to : Khaiser.","","","","cheque","3154","Khaiser");
INSERT INTO expenses VALUES("9829","1","","","2017-07-11","119","12000","Paid to : Khaiser.","","","","cheque","3159","Khaiser");
INSERT INTO expenses VALUES("9830","1","","","2017-11-07","124","100000","Loan amount return which was taken from Afaq.","","","","cheque","3318","Mohd Basha Ahmed");
INSERT INTO expenses VALUES("9831","1","","","2017-03-10","13","900","Paid unloading charges for 200 bags of cement.","","","","cash","","Labour");
INSERT INTO expenses VALUES("9832","1","","","2017-07-27","119","10000","Paid to : Nayeem.","","","","cheque","3183","Nayeem");
INSERT INTO expenses VALUES("9833","1","","","2017-08-11","119","5500","Paid to : Mustaq.","","","","cheque","3216","Mustaq");
INSERT INTO expenses VALUES("9834","1","","","2017-08-19","119","8000","Paid to : Jhangir.","","","","cheque","3225","Jhangir");
INSERT INTO expenses VALUES("9835","1","","","2017-09-06","119","10000","Paid to : Jhangir.","","","","cheque","3245","Jhangir");
INSERT INTO expenses VALUES("9836","1","","","2017-09-12","119","26000","Paid to : Gopal.","","","","cheque","3250","Gopal");
INSERT INTO expenses VALUES("9837","1","","","2017-10-18","119","10000","Paid to : Maqbool.","","","","cheque","3280","Maqbool");
INSERT INTO expenses VALUES("9838","1","","","2017-10-20","119","7500","Paid to : Ramachander.","","","","cheque","3300","Ramachander");
INSERT INTO expenses VALUES("9839","1","","","2017-10-26","119","11688","Paid to : Wahab.","","","","cheque","3297","M A Wahab");
INSERT INTO expenses VALUES("9840","1","","","2017-11-10","119","5500","Pai to : Amjad.","","","","cheque","3328","Amjad");
INSERT INTO expenses VALUES("9841","1","","","2017-11-10","119","4540","Paid to : Nayeem.","","","","cheque","3327","Nayeem");
INSERT INTO expenses VALUES("9842","1","","","2017-11-10","119","20000","Paid to : Ragwander.","","","","cheque","3331","Ragwander");
INSERT INTO expenses VALUES("9843","1","","","2017-11-24","119","4000","Paid to : Zeeshan","","","","cheque","3343","Zeeshan");
INSERT INTO expenses VALUES("9844","1","","","2017-11-30","119","30000","Paid to : Gopal.","","","","cheque","3351","Gopal");
INSERT INTO expenses VALUES("9845","1","","","2017-12-04","119","10000","Paid to : Gopal.","","","","cheque","3353","Gopal");
INSERT INTO expenses VALUES("9846","1","","","2017-12-26","119","1500","Paid to : Jahangir.","","","","cheque","3372","Jahangir");
INSERT INTO expenses VALUES("9847","1","","","2017-12-15","119","15000","Paid to : Majid.","","","","cheque","3365","Majid");
INSERT INTO expenses VALUES("9848","1","","","2018-03-06","129","20000","Purchase pipes for Pergi.","","","","cheque","3447","M Rajbhupal Reddy");
INSERT INTO expenses VALUES("9849","1","","","2018-03-03","119","52200","Paid to : M S Limra Traders.","","","","cheque","3458","M S Limra Traders");
INSERT INTO expenses VALUES("9850","1","","","2017-07-26","119","20000","Paid to : Anand.","","","","cheque","3179","Anand");
INSERT INTO expenses VALUES("9851","1","","","2017-09-29","14","5400","Bricks purchase in loose","","","","cash","","Basith");
INSERT INTO expenses VALUES("9852","1","","","2018-03-06","129","144000","TRFR TO:RANK SILICON AND INDUSTRIES.
\n","","","","cheque","3449","Sai Ram");
INSERT INTO expenses VALUES("9854","1","","","2018-07-21","107","8000","Paid labour payment.","","","","cheque","3543","Saddam");
INSERT INTO expenses VALUES("9855","1","","","2018-07-21","101","15000","Paid labour payment.","","","","cheque","3544","Jamal");
INSERT INTO expenses VALUES("9856","1","","","2018-07-21","10","13500","Paid labour payment.","","","","cheque","3545","Tirupathi");
INSERT INTO expenses VALUES("9857","1","","","2018-07-17","89","40000","Paid labour payment.","","","","cheque","3537","Ibrahim");
INSERT INTO expenses VALUES("9858","1","","","2018-07-13","120","9500","Paid salary.
\n","","","","cheque","3533","Ramesh");
INSERT INTO expenses VALUES("9859","1","","","2018-07-13","101","10000","Paid labour payment .
\n","","","","cheque","3532","Jamal");
INSERT INTO expenses VALUES("9860","1","","","2018-07-13","103","44500","Purchase Tiles from Patel.
\n","","","","cheque","3531","Patel");
INSERT INTO expenses VALUES("9861","1","","","2018-07-13","5","20000","Purchase sanitary material from J.K. Enterprises.","","","","cheque","3530","J K SANITARY");
INSERT INTO expenses VALUES("9862","1","","","2018-07-21","122","10100","Purchase Robo sand.
\n","","","","cheque","3542","Krishna ");
INSERT INTO expenses VALUES("9863","1","","","2018-07-23","105","50000","Paid labour payment.
\n","","","","cheque","3548","Mujahid");
INSERT INTO expenses VALUES("9864","1","","","2018-07-23","122","10700","Purchase Robo sand.","","","","cheque","3547","Krishna ");
INSERT INTO expenses VALUES("9865","1","","","2018-07-23","2","28000","Purchase cement.","","","","cheque","3549","Junaid");
INSERT INTO expenses VALUES("9866","1","","","2018-07-24","89","20000","Paid labour payment.","","","","cheque","3550","Ibrahim");
INSERT INTO expenses VALUES("9867","1","","","2018-07-24","97","5000","Paid labour payment to painter.
\n","","","","cheque","3551","Mazher");
INSERT INTO expenses VALUES("9868","1","","","2018-07-24","99","5000","Paid labour payment.","","","","cheque","","Yousuf");
INSERT INTO expenses VALUES("9869","1","","","2018-07-24","13","10000","Paid labour payment for shifting Robo sand.","","","","cheque","3555","Aqtar labour");
INSERT INTO expenses VALUES("9870","1","","","2018-07-25","8","30000","Purchase Doors.
\n","","","","cheque","3556","Srinivas");
INSERT INTO expenses VALUES("9871","1","","","2018-07-25","120","8000","Paid Salary for the month of July & Advance.
\n","","","","cheque","3557","Mahboob");
INSERT INTO expenses VALUES("9872","1","","","2018-07-26","13","10000","Paid labour payment for Ramp work.			","","","","cheque","3558","Miskeen");
INSERT INTO expenses VALUES("9873","1","","","2018-07-24","98","25000","Paid to :Ramu, Aqtar labour, Cement Hammali, Afzal T.C, Purchased 10 bags of Cement, Kabutar jali, e","","","","cheque","3553","Miskeen");
INSERT INTO expenses VALUES("9874","1","","","2018-07-28","122","10600","Purchased Robo sand. 			","","","","cheque","3559","Krishna ");
INSERT INTO expenses VALUES("9875","1","","","2018-07-28","13","4000","Paid labour payment for Ramp work.			
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("9876","1","","","2018-07-28","13","2000","Paid labour payment for Ramp work.
\n","","","","cash","","Labours");
INSERT INTO expenses VALUES("9877","1","","","2018-08-01","14","7000","Purchased Red Bricks.
\n","","","","cheque","3566","Basith");
INSERT INTO expenses VALUES("9878","1","","","2018-08-01","107","10000","Paid labour payment for Tiles Fitting.
\n","","","","cheque","3565","Shareef");
INSERT INTO expenses VALUES("9879","1","","","2018-08-01","89","10000","Paid Labour payment for Waterproofing.
\n","","","","cheque","3564","Ibrahim");
INSERT INTO expenses VALUES("9880","1","","","2018-08-01","100","10000","Paid labour payment for POP Work.","","","","cheque","3563","Shareef");
INSERT INTO expenses VALUES("9881","1","","","2018-08-01","5","22755","Purchased sanitary material.
\n","","","","cheque","3561","J K SANITARY");
INSERT INTO expenses VALUES("9882","1","","","2018-08-01","5","36533","Purchased sanitary material.
\n","","","","cheque","3562","J K SANITARY");
INSERT INTO expenses VALUES("9883","1","","","2017-01-02","120","9000","Paid Salary","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9884","1","","","2017-03-10","120","9000","Salary Paid","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9885","1","","","2017-04-11","120","9000","Paid Salary","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9886","1","","","2017-05-10","120","9000","Paid salary","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9887","1","","","2017-11-10","120","9000","Paid salary","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9888","1","","","2018-03-10","120","9500","paid salary","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9889","1","","","2017-04-03","120","4000","Paid salary","","","","cash","","Mahoob");
INSERT INTO expenses VALUES("9890","1","","","2017-05-02","120","4000","Paid salary","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9891","1","","","2017-06-06","120","4000","Paid salary","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9892","1","","","2017-07-05","120","4000","Paid salary","","","","cash","","Mahoob");
INSERT INTO expenses VALUES("9893","1","","","2017-12-27","120","44000","Paid salary from February 2017 to December 2017.","","","","cash","","Mahboob");
INSERT INTO expenses VALUES("9894","1","","","2018-07-06","101","10000","Paid labour payment.","","","","cheque","3520","Jamal");
INSERT INTO expenses VALUES("9895","1","","","2018-07-07","5","56576","Purchase sanitary material from SRI LAXMI SALES CORPORATION.","","","","cheque","3589","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9896","1","","","2018-07-07","101","20000","Paid labour payment.","","","","cheque","3523","Jamal");
INSERT INTO expenses VALUES("9897","1","","","2018-07-07","107","15000","Paid labour payment.","","","","cheque","3525","Saddam");
INSERT INTO expenses VALUES("9898","1","","","2018-07-07","10","25000","Paid labour payment.","","","","cheque","3526","Tirupathi");
INSERT INTO expenses VALUES("9899","1","","","2018-07-07","5","50000","TRFR TO: J K SANITARY & ELECTRICAL to purchase sanitary material.","","","","cheque","3522","J K SANITARY");
INSERT INTO expenses VALUES("9900","1","","","2018-07-07","104","5000","Paid labour payment.","","","","cheque","3524","Kamal");
INSERT INTO expenses VALUES("9901","1","","","2018-07-06","110","140000","TRFR TO: REHAN SHARIEF.","","","","cheque","3517","Rehan Sharief");
INSERT INTO expenses VALUES("9902","1","","","2018-07-09","14","21000","Purchased Red Bricks.","","","","cheque","3528","Basith");
INSERT INTO expenses VALUES("9903","1","","","2018-07-10","2","27500","Purchased cement from INDIA STEEL ENTERPRISES.","","","","cheque","3529","Junaid");
INSERT INTO expenses VALUES("9904","1","","","2018-07-13","10","19000","Paid labour payment.","","","","cheque","3534","Tirupathi");
INSERT INTO expenses VALUES("9905","1","","","2018-07-16","105","50000","Paid labour payment for Railing work.","","","","cheque","3535","Mujahid");
INSERT INTO expenses VALUES("9906","1","","","2018-07-16","118","531","Bank charges deducted. ","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9907","1","","","2018-07-17","118","295","Bank charges deducted.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9908","1","","","2018-07-19","77","20000","Purchased Electrical material from MUKESH ELECTRICALS.","","","","cheque","3538","DEVA");
INSERT INTO expenses VALUES("9909","1","","","2018-07-19","99","20000","Paid labour payment.","","","","cheque","3539","Yousuf");
INSERT INTO expenses VALUES("9910","1","","","2018-07-19","122","10600","Purchased Robo Sand.","","","","cheque","3540","Krishna ");
INSERT INTO expenses VALUES("9911","1","","","2018-07-20","89","30000","Paid labour payment.","","","","cheque","3541","Ibrahim");
INSERT INTO expenses VALUES("9912","1","","","2018-07-23","107","10000","Paid labour payment.","","","","cheque","3546","Shareef");
INSERT INTO expenses VALUES("9913","1","","","2018-07-06","1","20000","Sand purchased.","","","","cheque","3519","VENKATESH");
INSERT INTO expenses VALUES("9914","1","","","2018-07-07","100","40000","Paid for POP Work.","","","","cheque","3527","Shareef");
INSERT INTO expenses VALUES("9915","1","","","2018-07-06","122","17000","Purchased Robo Sand.","","","","cheque","3518","Ravi");
INSERT INTO expenses VALUES("9916","1","","","2018-07-18","118","1180","Bank charges deducted.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9917","1","","","2018-08-04","10","300000","Paid Advance payment.
\n","","","","cheque","3587","Tirupathi");
INSERT INTO expenses VALUES("9918","1","","","2018-08-04","10","10000","Paid labour payment.
\n","","","","cheque","3588","Tirupathi");
INSERT INTO expenses VALUES("9919","1","","","2018-08-07","103","30500","Rs 30000 for purchasing Tiles & Rs 500 for Transportation.","","","","cheque","3581","Hussain ");
INSERT INTO expenses VALUES("9921","1","","","2018-08-01","110","1","test","","","files/expenses/9921-2018-08-01.jpeg","cash","","test");
INSERT INTO expenses VALUES("9922","1","","","2018-08-01","13","5000","Paid for cleaning of Dismelting.
\n","","","","cheque","3560","Dismelting");
INSERT INTO expenses VALUES("9923","1","","","2018-08-18","97","20000","Paid labour payment to Painter.
\n","","","","cheque","3568","Mazher");
INSERT INTO expenses VALUES("9924","1","","","2018-08-16","13","7000","Paid for cleaning of Dismelting.
\n","","","","cheque","3569","Babu");
INSERT INTO expenses VALUES("9925","1","","","2018-08-16","8","10100","Purchased Doors for  Penthouse.
\n","","","","cheque","3570","Srinivasa");
INSERT INTO expenses VALUES("9926","1","","","2018-08-16","121","1400","Purchased Paint Material.
\n","","","","cheque","3567","Afsar");
INSERT INTO expenses VALUES("9927","1","","","2018-08-16","107","10000","Paid labour payment for Tiles Fitting.
\n","","","","cheque","3571","Saddam");
INSERT INTO expenses VALUES("9928","1","","","2018-08-13","105","70000","Purchased Lobby Railing Material.
\n","","","","cheque","3572","Mujahid");
INSERT INTO expenses VALUES("9929","1","","","2018-08-10","100","30000","Rs 30000 paid for material purchase. & Rs 15000 used for other Expenses.","","","","cheque","3574","Shareef");
INSERT INTO expenses VALUES("9930","1","","","2018-08-10","107","5000","Paid labour payment for Tiles Fitting.
\n","","","","cheque","3575","Saddam");
INSERT INTO expenses VALUES("9931","1","","","2018-08-10","97","21000","Paid labour payment to Painter.
\n","","","","cheque","3578","Mazhar");
INSERT INTO expenses VALUES("9932","1","","","2018-08-10","120","9500","Paid Salary for the month of July 2018.
\n","","","","cheque","3577","Ramesh");
INSERT INTO expenses VALUES("9933","1","","","2018-08-28","100","30000","Purchased Electrical Material.
\n","","","","cheque","3536","Shareef");
INSERT INTO expenses VALUES("9934","1","","","2018-08-07","8","8000","Paid for Door bidding + Transportation charges.	
\n","","","","cash","","Sandeep");
INSERT INTO expenses VALUES("9935","1","","","2018-08-08","8","24500","Door purchased.
\n","","","","cash","","Srinivasa");
INSERT INTO expenses VALUES("9936","1","","","2018-08-06","121","15200","Purchased Paint material.
\n","","","","cheque","3583","Afsar");
INSERT INTO expenses VALUES("9937","1","","","2018-08-06","121","286","Purchased hardware material.
\n","","","","cash","","J.N Paints");
INSERT INTO expenses VALUES("9938","1","","","2018-08-06","100","45000","Purchased material.
\n","","","","cheque","3584","Shareef");
INSERT INTO expenses VALUES("9939","1","","","2018-08-30","100","30000","Paid for material purchase.
\n","","","","cheque","3641","Shareef");
INSERT INTO expenses VALUES("9940","1","","","2018-08-30","105","50000","Paid for 2,3 & 6 Floor Lobby material.
\n","","","","cheque","3642","Mujahid");
INSERT INTO expenses VALUES("9941","1","","","2018-08-30","99","5000","Paid Labour Payment to Electrician.
\n","","","","cheque","3643","Yousuf");
INSERT INTO expenses VALUES("9942","1","","","2018-08-08","111","650","Paid Internet Bill.
\n","","","","cash","","Country online");
INSERT INTO expenses VALUES("9943","1","","","2018-08-29","13","4500","Paid labour payment for Robo Sand lifting.
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("9944","1","","","2018-08-31","13","4500","Paid labour payment for Robo Sand lifting.
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("9945","1","","","2018-08-10","89","10000","Paid Labour payment for Waterproofing.
\n","","","","cheque","3579","Ibrahim");
INSERT INTO expenses VALUES("9946","1","","","2018-08-31","122","14400","Purchase of 2 load of Robo Sand.
\n","","","","cheque","3644","Krishna ");
INSERT INTO expenses VALUES("9947","1","","","2018-09-01","119","21000","Paid to Ghouse for Transfer civil work.
\n","","","","cheque","","Ghouse");
INSERT INTO expenses VALUES("9948","1","","","2018-09-01","2","26200","Purchase of cement.
\n","","","","cheque","","India Steel Enterprises");
INSERT INTO expenses VALUES("9949","1","","","2018-08-06","102","100000","TRFR TO: FZAMI ONLINE SERVICES.
\n","","","","cheque","3582","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9950","1","","","2018-08-04","14","9400","Purchase of sand and red bricks.
\n","","","","cheque","3585","Basith");
INSERT INTO expenses VALUES("9951","1","","","2018-08-07","107","10000","Paid labour payment for Floor Tiles fitting charges.
\n","","","","cheque","3586","Shareef");
INSERT INTO expenses VALUES("9952","1","","","2018-08-09","121","9751","Purchased Paint Material.","","","","cheque","3580","Afsar");
INSERT INTO expenses VALUES("9953","1","","","2018-08-10","121","5000","Purchased Paint Material.","","","","cheque","3573","Afsar");
INSERT INTO expenses VALUES("9954","1","","","2018-09-01","97","13000","Paid Labour Payment.","","","","cheque","3649","Mazhar");
INSERT INTO expenses VALUES("9955","1","","","2018-09-01","13","9000","Paid labor payment for shifting tiles.
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("9956","1","","","2018-09-05","105","50000","Paid for Pent House Windows.
\n","","","","cheque","3650","Mujahid");
INSERT INTO expenses VALUES("9957","1","","","2018-09-06","100","45000","Paid for Material Purchase.
\n","","","","cheque","3652","Shareef");
INSERT INTO expenses VALUES("9958","1","","","2018-09-07","116","7500","Paid Door fitting Charges.
\n","","","","cheque","3653","Shabbir");
INSERT INTO expenses VALUES("9959","1","","","2018-09-07","107","10000","Paid labour payment for Tiles Fitting.
\n","","","","cheque","3654","Shareef");
INSERT INTO expenses VALUES("9960","1","","","2018-09-07","8","30000","Purchased Door Locks.
\n","","","files/expenses/9960-2018-09-07.jpg","cheque","3655","Razzaq");
INSERT INTO expenses VALUES("9961","1","","","2018-08-31","5","3268","Purchased Sanitary material
\n","","","files/expenses/9961-2018-08-31.jpg","cash","","J K SANITARY");
INSERT INTO expenses VALUES("9962","1","","","2018-08-04","13","1600","Paid labour payment for cleaning.
\n","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("9963","1","","","2018-09-10","97","20000","Paid Labour Payment to Painter.
\n","","","","cheque","3656","Mazhar");
INSERT INTO expenses VALUES("9964","1","","","2018-09-11","125","20000","Paid Labour Payment to Welder.
\n","","","","cheque","3657","Sajid");
INSERT INTO expenses VALUES("9965","1","","","2018-09-11","97","8000","Paid Labour Payment to Painter.
\n","","","","cheque","3658","Mazhar");
INSERT INTO expenses VALUES("9966","1","","","2018-09-11","97","10000","Paid labor payment to painter.","","","","cheque","3659","Mazhar");
INSERT INTO expenses VALUES("9967","1","","","2018-09-12","77","18000","Purchase Electrical Material from Mukesh Electricals.
\n","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("9968","1","","","2018-09-11","103","2400","Purchased Tiles.
\n","","","files/expenses/9968-2018-09-11.jpg","cash","","Crystal Tiles");
INSERT INTO expenses VALUES("9969","1","","","2018-09-12","121","5800","Purchased Paint Material.
\n","","","files/expenses/9969-2018-09-12.jpg","cash","","Amego Paints");
INSERT INTO expenses VALUES("9970","1","","","2018-09-17","105","20000","Paid for Railing Work.
\n","","","","cash","","Mujahid");
INSERT INTO expenses VALUES("9971","1","","","2018-09-17","122","7000","Purchased Robo Sand.
\n","","","","cash","","Krishna ");
INSERT INTO expenses VALUES("9972","1","","","2018-09-22","97","8000","Paid Labour Payment to Painter.
\n","","","","cash","","Mazhar");
INSERT INTO expenses VALUES("9973","1","","","2018-09-22","100","15000","Paid labour payment.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("9974","1","","","2018-09-20","107","10000","Paid labour payment for Tiles Fitting.
\n","","","","cash","","Saddam");
INSERT INTO expenses VALUES("9975","1","","","2018-09-15","97","19000","Paid Labour Payment to Painter.
\n","","","","cheque","3661","Mazhar");
INSERT INTO expenses VALUES("9976","1","","","2018-09-25","8","8100","Purchased Door Bidding + Transportation Charges. 
\n","","","","cash","","Sandeep");
INSERT INTO expenses VALUES("9977","1","","","2018-09-27","77","102000","Purchased Electricity Meters & Transformer +Transportation Charges .( Loan Taken from Happy Scholar ","","","","cash","","ABDUL ALEEM MOHAMMED");
INSERT INTO expenses VALUES("9978","1","","","2018-09-30","100","25000","Purchased  Material.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("9979","1","","","2018-09-30","97","12000","Paid Labour Payment to Painter.
\n","","","","cash","","Mazhar");
INSERT INTO expenses VALUES("9980","1","","","2018-09-15","107","20000","Paid labour payment for Tiles Fitting.
\n","","","","cheque","3662","Saddam");
INSERT INTO expenses VALUES("9981","1","","","2018-09-01","125","30000","Paid Labour Payment to Welder.
\n","","","","cheque","3647","Sajid");
INSERT INTO expenses VALUES("9982","1","","","2018-09-18","114","120000","Purchased Steels.
\n","","","","cheque","3660","H S M Steels");
INSERT INTO expenses VALUES("9983","1","","","2018-10-01","120","5000","Paid Salary for the month of Sept. 2018.
\n","","","","cash","","Mahboob ");
INSERT INTO expenses VALUES("9984","1","","","2018-10-05","100","20000","Purchased Material.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("9985","1","","","2018-09-05","102","12770","TRFR TO: Sneha Arora Paid TDS for the month of Aug. 2018.","","","","bank transfer","","Sneha Arora");
INSERT INTO expenses VALUES("9986","1","","","2018-10-06","103","100000","Paid due amt. of F.Tiles which was purchased on 18-Sept.
\n","","","","cash","","Hussain");
INSERT INTO expenses VALUES("9987","1","","","2018-10-11","100","20000","Material Purchased for Lobby.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("9988","1","","","2018-10-11","103","100000","Purchased  F.Tiles for 3 Flats, & Old due clear.
\n","","","","cash","","Hussain");
INSERT INTO expenses VALUES("9989","1","","","2018-10-12","13","1600","Paid for cleaning dismeltling.
\n
\n","","","","cash","","Hasham");
INSERT INTO expenses VALUES("9990","1","","","2018-10-12","13","4400","Paid labour payment for lifting Robo Sand 3rd floor.
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("9991","1","","","2018-10-12","13","1600","Paid labour payment for lifting F.Tiles on 3rd floor.
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("9992","1","","","2018-10-13","119","900","Paid for News paper Advertisement.
\n","","","","cash","","Siasat News Paper");
INSERT INTO expenses VALUES("9993","1","","","2018-10-16","100","30000","Material Purchase for Lobby.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("9994","1","","","2018-10-16","77","80000","Purchased Wires from mukesh electricals.
\n","","","","cash","","Mukesh Electricals");
INSERT INTO expenses VALUES("9995","1","","","2018-10-16","107","20000","Paid labour payment for Tiles fitting.
\n","","","","cheque","3682","Saddam");
INSERT INTO expenses VALUES("9996","1","","","2018-10-26","119","12000","Amt. taken from FZAMI to purchase wires of CCTV Cameras.
\n","","","","bank transfer","3724","A1 Computers Service");
INSERT INTO expenses VALUES("9997","1","","","2018-10-12","122","7000","Purchased  Robo Sand.
\n","","","","cash","","Krishna ");
INSERT INTO expenses VALUES("9998","1","","","2018-10-27","122","8000","Purchased Robo Sand.
\n","","","","cash","","Krishna ");
INSERT INTO expenses VALUES("9999","1","","","2018-10-27","13","5100","Paid labour payment for lifting Robo Sand.
\n","","","","cash","","Aqtar labour");
INSERT INTO expenses VALUES("10000","1","","","2018-10-29","5","780","	Purchased GUM for kitchen platform Tiles.
\n","","","","cash","","J K SANITARY");
INSERT INTO expenses VALUES("10001","1","","","2018-10-30","8","12000","Paid Adv. For Door purchase.
\n","","","","cash","","Srinivasa");
INSERT INTO expenses VALUES("10002","1","","","2018-10-31","104","1800","Paid labour payment for granite fixing of penthouse kitchen.
\n","","","","cash","","Kamal");
INSERT INTO expenses VALUES("10003","1","","","2018-10-31","100","18000","Paid POP labour payment.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("10004","1","","","2018-10-31","119","3000","Paid for News paper Advertisement.
\n","","","","cash","","News Paper Advertisement");
INSERT INTO expenses VALUES("10005","1","","","2018-11-01","8","2000","Purchased Doors.
\n","","","","cash","","Srinivasa");
INSERT INTO expenses VALUES("10006","1","","","2018-11-02","103","13500","Purchase of Bathroom Tiles for flat No. 505.
\n","","","","cash","","Ceramic Town");
INSERT INTO expenses VALUES("10007","1","","","2018-11-02","77","26000","Purchase of Main line Wires.
\n","","","","cash","","Mukesh Electricals");
INSERT INTO expenses VALUES("10008","1","","","2018-11-02","100","45000","Purchase of POP materials.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("10009","1","","","2018-11-03","101","5500","Rectification of flat 505 and 301
\n","","","","cash","","Jamaal");
INSERT INTO expenses VALUES("10010","1","","","2018-11-04","120","5000","Paid salary for the month October 2018.
\n","","","","cash","","Mahboob ");
INSERT INTO expenses VALUES("10011","1","","","2018-11-08","1","56000","Purchased 1 load of Sand.
\n","","","","cash","","Venkatesh");
INSERT INTO expenses VALUES("10012","1","","","2018-11-08","2","30500","Purchased 120 Bags of Cement from INDIA STEEL ENTERPRISES.","","","","bank transfer","3663","Junaid");
INSERT INTO expenses VALUES("10013","1","","","2018-11-08","2","700","Hammali for 120 Bags of Cement.
\n","","","","cash","","Labour");
INSERT INTO expenses VALUES("10014","1","","","2018-11-08","89","2000","Paid labour payment for Water Proofing.
\n","","","","cheque","3695","Ibrahim");
INSERT INTO expenses VALUES("10015","1","","","2018-11-12","107","15000","Paid labour payment for Tiles Fitting.
\n","","","","cash","","Saddam");
INSERT INTO expenses VALUES("10016","1","","","2018-11-12","120","9500","Paid November salary to Watchman.
\n","","","","cash","","Ramesh");
INSERT INTO expenses VALUES("10017","1","","","2018-11-16","100","30000","Purchase of POP Material.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("10018","1","","","2018-11-16","100","11000","Paid labour payment for POP Work.
\n","","","","cash","","Shareef");
INSERT INTO expenses VALUES("10019","1","","","2018-11-16","99","11000","Paid Labour payment to Electrician.
\n","","","","cash","","Asif Electrician");
INSERT INTO expenses VALUES("10020","1","","","2018-11-17","5","110","Purchased 1 Pack of Sponge.
\n","","","","cash","","Aladin Traders");
INSERT INTO expenses VALUES("10021","1","","","2018-11-17","10","12000","Paid Labour payment.
\n","","","","cash","","Tirupathy");
INSERT INTO expenses VALUES("10023","1","","","2018-11-19","107","19000","Paid labor payment for Tiles Fitting.","","","","cash","","Saddam");
INSERT INTO expenses VALUES("10024","1","","","2018-11-24","5","32000","Purchased Sanitary material for Pent House.
\n","","","","cash","","Jamal");
INSERT INTO expenses VALUES("10025","1","","","2018-11-24","103","41000","Purchased F.Tiles + Transportation Charges.
\n","","","","cash","","Hussain Tiles");
INSERT INTO expenses VALUES("10026","1","","","2018-11-24","10","8000","Paid Labor Payment.
\n","","","","cash","","Tirupathy");
INSERT INTO expenses VALUES("10027","1","","","2018-11-27","97","10000","Paid Labour Payment to Painter.
\n","","","","cash","","Mazhar");
INSERT INTO expenses VALUES("10028","1","","","2018-12-01","10","10000","Paid Labour Payment.
\n","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("10029","1","","","2018-12-02","107","10000","Paid Labour Payment for Tiles Fitting.
\n","","","","cash","","Saddam");
INSERT INTO expenses VALUES("10030","1","","","2019-01-23","121","8250","Purchase material","","","","cash","","Omri Traders");
INSERT INTO expenses VALUES("10031","1","","","2019-01-14","121","9350","Purchase material","","","","cash","","Omri Traders");
INSERT INTO expenses VALUES("10032","1","","","2019-01-02","130","20190","Purchase material","","","","cash","","Razzaq Traders");
INSERT INTO expenses VALUES("10033","1","","","2019-01-21","131","13365","Door Bidding purchase","","","","cash","","Rajesh");
INSERT INTO expenses VALUES("10034","1","","","2018-12-03","121","1925","Purchase material 1805+120","","","","cheque","3717","Omri Traders");
INSERT INTO expenses VALUES("10035","1","","","2019-01-08","111","1950","Internet bill for 2 months","","","","cheque","003702","Country Online");
INSERT INTO expenses VALUES("10036","1","","","2019-01-15","8","67000","Internal doors purchase for 3 floor.","","","","cash","","Srinivas");
INSERT INTO expenses VALUES("10037","1","","","2019-02-02","8","21328","9 Main door purchase.","","","","cash","","Srinivas");
INSERT INTO expenses VALUES("10038","1","","","2019-02-03","97","16000","Labour payment","","","","cash","","Mazhar");
INSERT INTO expenses VALUES("10039","1","","","2019-02-02","99","10000","Labour payment","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("10040","1","","","2019-02-05","130","13800","For 9 Main doors.","","","","cash","","Razzaq Traders");
INSERT INTO expenses VALUES("10041","1","","","2019-02-01","121","1300","Door lappum purchase","","","","cash","","Amego Paints");
INSERT INTO expenses VALUES("10042","1","","","2017-11-29","10","56000","Paid for Sendrying.","","","","cheque","3345","Tirupathi");
INSERT INTO expenses VALUES("10043","1","","","2018-01-10","10","41000","Rs 26000 Paid for Sump Slab & Rs 15000 for Partition.","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("10044","1","","","2018-01-12","10","5000","Paid to Sinu for Tank Walls.","","","","cash","","Sinu");
INSERT INTO expenses VALUES("10045","1","","","2018-02-17","10","30000","Paid to Sinu for Tank Slab.","","","","cheque","3435","Sinu");
INSERT INTO expenses VALUES("10046","1","","","2018-02-24","10","22000","Paid labor payment for Tank Slab.","","","","cash","","Sinu");
INSERT INTO expenses VALUES("10047","1","","","2018-02-24","10","34000","Paid for sendrying work for Tank.","","","","cheque","3472","Sinu");
INSERT INTO expenses VALUES("10048","1","","","2018-05-12","10","15000","Paid Labor payment.","","","","cheque","3621","Tirupathi");
INSERT INTO expenses VALUES("10049","1","","","2018-07-30","10","10000","Paid Labor payment.","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("10050","1","","","2018-07-31","10","8000","Paid labor payment.","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("10051","1","","","2019-01-04","10","100000","Paid advance cheque.","","","","cheque","","Tirupathi");
INSERT INTO expenses VALUES("10052","1","","","2019-05-30","10","21000","Paid Labor payment.","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("10053","1","","","2019-04-08","10","35000","Paid labor payment.","","","","cash","","Tirupathi");
INSERT INTO expenses VALUES("10054","1","","","2019-01-05","97","11500","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10055","1","","","2019-01-14","97","15000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10056","1","","","2019-01-20","97","22000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10057","1","","","2019-01-27","97","21000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10058","1","","","2019-02-09","97","15000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10059","1","","","2019-02-17","97","3000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10060","1","","","2019-03-05","97","20000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10061","1","","","2019-03-13","97","9000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10062","1","","","2019-03-14","97","50000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10063","1","","","2019-03-16","97","14000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10064","1","","","2019-03-24","97","3500","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10065","1","","","2019-04-08","97","20000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10066","1","","","2019-04-20","97","8500","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10067","1","","","2019-04-25","97","3000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10068","1","","","2019-04-29","97","16000","Paid labour payment to Painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10069","1","","","2019-05-18","97","12000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10070","1","","","2019-05-18","97","10000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10071","1","","","2019-05-18","97","2500","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10072","1","","","2019-05-18","97","10000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10073","1","","","2019-05-27","97","8000","Paid labour payment to painter.","","","","cheque","","MAZHAR");
INSERT INTO expenses VALUES("10074","1","","","2019-06-15","97","2000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10075","1","","","2019-06-25","97","4000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10076","1","","","2019-06-28","97","16000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10077","1","","","2019-06-28","97","10000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10078","1","","","2019-07-16","97","20000","Paid labour payment to painter.","","","","cash","","MAZHAR");
INSERT INTO expenses VALUES("10079","1","","","2019-07-30","97","20000","Paid labour payment to painter.","","","","cash","","MAZHAR");



DROP TABLE investments;

CREATE TABLE `investments` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `investor` int(3) NOT NULL,
  `date` date NOT NULL,
  `amount` float NOT NULL,
  `particulars` varchar(100) NOT NULL,
  `payment_method` enum('cash','cheque','bank transfer') NOT NULL,
  `payment_details` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=latin1;

INSERT INTO investments VALUES("17","6","2018-01-10","1000000","Received Rs 10,00,000/- ten lakhs. Total amount in fzami is Rs 13 lakhs. ","bank transfer","");
INSERT INTO investments VALUES("19","10","2016-06-10","500000","Cash deposite in bank to give payment to Rank Silicon.","cash","");
INSERT INTO investments VALUES("20","10","2016-06-07","100000","For opening of Sweet Homes account.","cash","");
INSERT INTO investments VALUES("22","10","2016-08-08","500000","By cash","cash","");
INSERT INTO investments VALUES("24","10","2016-08-01","500000","By cash","cash","");
INSERT INTO investments VALUES("26","10","2016-09-17","700000","By cash","cash","");
INSERT INTO investments VALUES("27","10","2016-09-19","175000","BY CASH - MEHDIPATNAM","cash","");
INSERT INTO investments VALUES("28","10","2016-09-19","500","By cash","cash","");
INSERT INTO investments VALUES("32","10","2016-10-13","365000","By cash","cash","");
INSERT INTO investments VALUES("35","10","2017-03-30","200000","BY CASH - HYDERABAD - TOLICHOWKI","cash","");
INSERT INTO investments VALUES("42","11","2016-08-17","70000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("43","11","2016-12-19","180000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("44","11","2016-12-22","120000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("45","11","2016-12-27","150000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("46","11","2017-01-06","300000","TRFR FROM:FZAMI ONLINE  SERVICES","bank transfer","");
INSERT INTO investments VALUES("47","10","2017-01-27","40000","BIL/001134645051/Sweet homes/NSP","cash","");
INSERT INTO investments VALUES("48","11","2017-02-03","666813","TRFR FROM:FZAMI ONLINES SERVICES","bank transfer","");
INSERT INTO investments VALUES("49","11","2017-02-10","400000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("50","8","2017-02-13","500000","HANNAN YOUSUF QSBH  111786","bank transfer","");
INSERT INTO investments VALUES("51","11","2017-02-18","500000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("52","11","2017-02-22","500000","TRFR FROM:FZAMI ONLINE","bank transfer","");
INSERT INTO investments VALUES("53","11","2017-03-06","250000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("54","11","2017-03-10","125000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("55","11","2017-03-14","500000","TRFR FROM:FZAMI ONLINE SERVICES
\n","bank transfer","");
INSERT INTO investments VALUES("56","11","2017-03-24","300000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("57","11","2017-03-30","100000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("66","11","2017-04-12","80000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("67","11","2017-04-25","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("68","11","2017-04-29","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("69","11","2017-05-03","130000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("70","11","2017-05-06","700000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("71","10","2017-04-07","200000","By cash - Hyderabad Tolichowki","bank transfer","");
INSERT INTO investments VALUES("72","11","2017-05-26","100000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("73","11","2017-06-01","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("74","11","2017-06-09","400000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("75","11","2017-06-17","40000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("76","11","2017-06-20","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("77","11","2017-07-01","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("78","11","2017-07-06","100000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("80","11","2017-07-11","1000000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("81","11","2017-08-02","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("82","11","2017-08-11","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("83","11","2017-08-16","800000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("84","11","2017-09-08","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("85","11","2017-09-12","75000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("86","11","2017-09-15","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("87","11","2017-09-29","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("88","11","2017-10-11","100000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("89","11","2017-10-16","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("90","11","2017-10-30","400000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("91","11","2017-11-29","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("92","10","2017-10-26","11688","By cash - Hyderabad Tolichowki","bank transfer","");
INSERT INTO investments VALUES("94","10","2018-01-10","10000","By cash - Hyderabad Tolichowki","bank transfer","");
INSERT INTO investments VALUES("95","11","2018-01-31","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("96","11","2018-02-09","400000","Transfer from FZAMI ONLINE SERVICE
\n","bank transfer","");
INSERT INTO investments VALUES("97","11","2018-02-23","500000","Transfer from FZAMI ONLINE SERVICE
\n","bank transfer","");
INSERT INTO investments VALUES("98","11","2018-02-27","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("99","11","2018-03-06","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("100","10","2017-07-14","75000","Cash Deposited in Bank.","cash","");
INSERT INTO investments VALUES("101","8","2017-10-07","53000","NEFT-RETURN-000033567646-INDIA STEEL ENTERPRISES-","bank transfer","");
INSERT INTO investments VALUES("102","8","2017-11-06","500000","VJB             VJB   634376","bank transfer","");
INSERT INTO investments VALUES("103","8","2017-11-07","200000","SYB            SYB  171225","bank transfer","");
INSERT INTO investments VALUES("104","7","2017-12-15","200000","TRFR FROM:AL AZEEM DAIRY","bank transfer","");
INSERT INTO investments VALUES("105","7","2017-12-22","200000","TRFR FROM:AL AZEEM DAIRY","bank transfer","");
INSERT INTO investments VALUES("106","8","2018-01-02","30000","TRFR FROM: MOHAMMAD NIZAMUDDIN QURESHI NADEEM JT1","bank transfer","");
INSERT INTO investments VALUES("107","8","2018-01-19","200000","SYB            SYB  705057","bank transfer","");
INSERT INTO investments VALUES("108","8","2018-01-19","100000","SYB            SYB  705059","bank transfer","");
INSERT INTO investments VALUES("109","8","2018-02-27","1000000","VIJAYA BANK/279304/VJB. Loan from Afaq.","bank transfer","");
INSERT INTO investments VALUES("110","8","2018-03-23","200000","TRFR FROM: HAPPY SCHOLAR","bank transfer","");
INSERT INTO investments VALUES("111","11","2018-04-06","500000","Amount transfer from Fzami.","bank transfer","");
INSERT INTO investments VALUES("112","11","2018-04-09","100000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("113","11","2018-04-16","60000","TRFR FROM: FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("114","8","2018-04-24","100000","TRFR FROM: HAPPY SCHOLAR. Loan taken.","bank transfer","");
INSERT INTO investments VALUES("115","10","2018-05-25","200000","CAM/CASH DEPOSIT/HYDERABAD-TOLICHOWKI.","cash","");
INSERT INTO investments VALUES("116","10","2018-05-21","200000","CAM/CASH DEPOSIT/HYDERABAD-TOLICHOWKI.","cash","");
INSERT INTO investments VALUES("117","10","2018-05-11","30000","TRFR FROM: HAPPY SCHOLAR.","bank transfer","");
INSERT INTO investments VALUES("118","8","2018-05-02","500000","LAIBA EDUCATIONAL SOCIETY. loan taken.","bank transfer","");
INSERT INTO investments VALUES("119","8","2018-05-07","150000","LAIBA EDUCATIONAL SOCIETY. Loan taken.","bank transfer","");
INSERT INTO investments VALUES("120","8","2018-06-11","50000","Loan taken from Trust.","bank transfer","");
INSERT INTO investments VALUES("121","7","2016-04-24","240000","From Aafaq (Nampally 9246561056) ","cash","");
INSERT INTO investments VALUES("122","6","2016-04-29","99000","Transfer to Yasmeen Account","bank transfer","");
INSERT INTO investments VALUES("123","6","2016-05-03","899532","RTGS-SCBLR22016050300001149-MTFX INC.-06752400140","bank transfer","");
INSERT INTO investments VALUES("124","7","2016-03-16","140000","Direct nadeem bhai paid Amount paid to waffi for designing.","cash","");
INSERT INTO investments VALUES("125","12","2016-05-20","1000000","Received 10 lacks from ameen bhai ","cash","");
INSERT INTO investments VALUES("126","7","2016-06-09","1500000","Amount received through Babu ","cash","");
INSERT INTO investments VALUES("127","12","2016-06-20","341000","Dollars transfer to jawad","cash","");
INSERT INTO investments VALUES("128","12","2016-07-26","201900","3000/- Dollars exchange @ 67.30 ","cash","");
INSERT INTO investments VALUES("129","7","2016-08-01","1000000","Amount transfer from Nadeem Bhai	
\n","cash","");
INSERT INTO investments VALUES("130","7","2016-08-08","328000","5000 Dollars transfer to SWEET HOMES 	
\n","cash","");
INSERT INTO investments VALUES("131","7","2016-08-23","1500000","Received amount from Nadeem Bhai
\n","cash","");
INSERT INTO investments VALUES("132","7","2016-09-17","1000000","Amount transfer from Nadeem Bhai	
\n","cash","");
INSERT INTO investments VALUES("133","7","2016-09-20","500000","Amount transfer from Nadeem Bhai
\n","cash","");
INSERT INTO investments VALUES("134","7","2016-10-03","100000","Amount transfer 	
\n","cash","");
INSERT INTO investments VALUES("135","7","2016-10-06","1000000","Amount transfer
\n","cash","");
INSERT INTO investments VALUES("136","7","2016-12-13","980000","From Babu Canada","cash","");
INSERT INTO investments VALUES("137","7","2017-01-25","190000","Amount transfer BABU	
\n","cash","");
INSERT INTO investments VALUES("138","7","2017-01-08","500000","Cash deleviry to Nadeem bhai hand	
\n","cash","");
INSERT INTO investments VALUES("139","11","2018-06-19","100000","TRFR FROM: FZAMI ONLINE SERVICES.
\n","bank transfer","");
INSERT INTO investments VALUES("140","11","2018-06-25","100000","TRFR FROM: FZAMI ONLINE SERVICES.
\n","bank transfer","");
INSERT INTO investments VALUES("141","12","2017-03-25","800000","Amount received from Amair father in law.","cash","");
INSERT INTO investments VALUES("142","11","2018-07-06","400000","TRFR FROM: FZAMI ONLINE SERVICES.","bank transfer","");
INSERT INTO investments VALUES("143","11","2018-07-09","50000","TRFR FROM: FZAMI ONLINE SERVICES.","bank transfer","");
INSERT INTO investments VALUES("144","11","2018-07-13","500000","Amount received from Fzami.","bank transfer","");
INSERT INTO investments VALUES("145","11","2018-07-25","50000","Amount received from FZAMI.","bank transfer","");
INSERT INTO investments VALUES("146","11","2018-09-09","100000","TRFR FROM: FZAMI ONLINE SERVICES.","bank transfer","");
INSERT INTO investments VALUES("147","11","2018-09-09","50000","TRFR FROM: FZAMI ONLINE SERVICES.
\n","bank transfer","");
INSERT INTO investments VALUES("149","8","2018-09-27","100000","Loan Taken from HAPPY SCHOLAR for Electricity  meters & Transformer.
\n","cash","");
INSERT INTO investments VALUES("150","10","2018-09-17","99000","Cash Deposited in Bank.","cash","");
INSERT INTO investments VALUES("151","9","2018-08-01","100000","TRFR FROM: MOHAMMAD NIZAMUDDIN QURESHI NADEEM 		","bank transfer","");
INSERT INTO investments VALUES("156","8","2018-10-16","110000","Loan Taken from Happy Scholar for construction work.
\n","cheque","387");
INSERT INTO investments VALUES("158","13","2018-04-17","300000","Sale of flat No 303, Advance amount received.","cash","");
INSERT INTO investments VALUES("159","13","2018-05-09","200000","2nd Advance amount received for sale of Flat No. 303.","cash","");
INSERT INTO investments VALUES("161","13","2018-08-04","500000","Flat 301. Total Adv 13 Lakhs. 5 lakhs deposited in Fzami on 31 july. Now TRF to Sweet Homes.","bank transfer","");
INSERT INTO investments VALUES("162","13","2018-08-16","300000","TRF:FZAMI thru adv of Flat 301 which was deposit in fzami","bank transfer","");
INSERT INTO investments VALUES("163","13","2018-08-10","200000","Adv of Flat 301 which was deposit in fzami was transfer to sweet homes.","bank transfer","");
INSERT INTO investments VALUES("164","13","2018-09-11","100000","Adv of Flat 301 which was deposit in fzami was transfer to sweet homes.","bank transfer","");
INSERT INTO investments VALUES("165","13","2018-09-05","100000","Rs 100000 return from FZAMI Which was deposited by sir Rs 792000 on 4-8-18 in FZAMI account.
\n","bank transfer","");
INSERT INTO investments VALUES("166","13","2018-09-05","50000","Rs 50000 return from FZAMI which was deposited by sir i. e., Rs 792000 on 4-8-18 in FZAMI account.
\n","bank transfer","");



DROP TABLE investor;

CREATE TABLE `investor` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `phone` bigint(12) NOT NULL,
  `address` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO investor VALUES("6","WIRE THRU BANK","9030747606","ICICI BANK.");
INSERT INTO investor VALUES("7","BABU PATEL","8686147088","CASH.");
INSERT INTO investor VALUES("8","LOAN TAKEN","12","HYD");
INSERT INTO investor VALUES("9","GOWAY","0","Canada");
INSERT INTO investor VALUES("10","CASH DEPOSITE","8686147088","Tolichowki.");
INSERT INTO investor VALUES("11","FZAMI TRANSFER","786","Hyderabad");
INSERT INTO investor VALUES("12","OTHERS RESOURCES","22","44");
INSERT INTO investor VALUES("13","PURCHASERS ","1233","HYD.");



DROP TABLE project;

CREATE TABLE `project` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `project_name` varchar(40) NOT NULL,
  `no_floors` int(2) NOT NULL,
  `start_date` date NOT NULL,
  `project_address` varchar(40) NOT NULL,
  `project_details` varchar(120) NOT NULL,
  `photo` varchar(30) NOT NULL,
  `no_flats` int(3) NOT NULL,
  `flats` varchar(200) NOT NULL,
  `type` enum('mt','ct') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO project VALUES("9","Azeem Heights","5","2017-01-30","Mehdipatnam","370 Sq Yds","","15","101 - 503","ct");



DROP TABLE user;

CREATE TABLE `user` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `username` varchar(15) NOT NULL,
  `password` varchar(10) NOT NULL,
  `email` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO user VALUES("1","admin","admin123","");



DROP TABLE work_type;

CREATE TABLE `work_type` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `work_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=latin1;

INSERT INTO work_type VALUES("1","SAND");
INSERT INTO work_type VALUES("2","CEMENT");
INSERT INTO work_type VALUES("5","SANITARY");
INSERT INTO work_type VALUES("8","DOOR & FRAMES");
INSERT INTO work_type VALUES("9","SENU (Labour payment)");
INSERT INTO work_type VALUES("10","TRUPATTY (Labour payment)");
INSERT INTO work_type VALUES("11","REDDY MIX");
INSERT INTO work_type VALUES("12","PIN AND VIBRATOR");
INSERT INTO work_type VALUES("13","DEPARTMENT LABOUR");
INSERT INTO work_type VALUES("14","BRICKS");
INSERT INTO work_type VALUES("18","CHIPPING LABOUR & GOA MAKING");
INSERT INTO work_type VALUES("77","ELECTRICAL MATERIAL");
INSERT INTO work_type VALUES("89","WATER PROFFING");
INSERT INTO work_type VALUES("95","ELECTRICITY BILL");
INSERT INTO work_type VALUES("97","PAINTER");
INSERT INTO work_type VALUES("98","MISCELLANEOUS");
INSERT INTO work_type VALUES("99","ELECTRICIAN");
INSERT INTO work_type VALUES("100","POP WORK");
INSERT INTO work_type VALUES("101","PLUMBER");
INSERT INTO work_type VALUES("102","FZAMI ONLINE SERVICES");
INSERT INTO work_type VALUES("103","TILES PURCHASE");
INSERT INTO work_type VALUES("104","GRANITE FITTING ");
INSERT INTO work_type VALUES("105","ALUMINIUM FITTING");
INSERT INTO work_type VALUES("107","TILES FITTING");
INSERT INTO work_type VALUES("110","LIFT ");
INSERT INTO work_type VALUES("111","INTERNET");
INSERT INTO work_type VALUES("112","ZAKI PLUMBER");
INSERT INTO work_type VALUES("113","GRANITE PURCHASE");
INSERT INTO work_type VALUES("114","STEELS");
INSERT INTO work_type VALUES("115","TATA BILLS");
INSERT INTO work_type VALUES("116","CARPENTER");
INSERT INTO work_type VALUES("117","NADEEM BHAI PERSONAL");
INSERT INTO work_type VALUES("118","BANK CHARGES");
INSERT INTO work_type VALUES("119","ONE TIME PAYMENT");
INSERT INTO work_type VALUES("120","SALARIES");
INSERT INTO work_type VALUES("121","PAINT MATERIAL");
INSERT INTO work_type VALUES("122","ROBO SAND");
INSERT INTO work_type VALUES("123","DESIGNING & OTHER FEES");
INSERT INTO work_type VALUES("124","LOAN AMOUNT RETURN");
INSERT INTO work_type VALUES("125","WELDER ");
INSERT INTO work_type VALUES("126","KANKAR");
INSERT INTO work_type VALUES("127","BRIBE");
INSERT INTO work_type VALUES("129","AMOUNT RETURN TO AFAQ HYDER");
INSERT INTO work_type VALUES("130","HARDWARE");
INSERT INTO work_type VALUES("131","BIDDING");



